/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.DrivelineClient;
import driveline.DrivelineException;
import driveline.StreamId;
import driveline.protocol.AppendOptions;
import java.util.Collection;
import java.util.Objects;

public class Stream {
    final StreamId streamId;
    private final DrivelineClient client;

    Stream(DrivelineClient client, StreamId streamId) {
        Objects.requireNonNull(client);
        Objects.requireNonNull(streamId);
        this.client = client;
        this.streamId = streamId;
    }

    public void append(byte[] data) throws DrivelineException {
        this.client.append(this.streamId, data, new AppendOptions());
    }

    public void append(byte[] data, AppendOptions options) throws DrivelineException {
        this.client.append(this.streamId, data, options);
    }

    public void append(Collection<byte[]> messages) throws DrivelineException {
        this.append(messages, new AppendOptions());
    }

    public void append(Collection<byte[]> messages, AppendOptions options) throws DrivelineException {
        for (byte[] message : messages) {
            this.client.append(this.streamId, message, options);
        }
    }

    public void truncate() throws DrivelineException {
        this.client.truncate(this.streamId);
    }

    public void close() {
        this.client.closeStream(this);
    }
}

