/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class Result<F, R> {
    public static <F, R> Result<F, R> ok(R result) {
        Objects.requireNonNull(result);
        return new Ok(result);
    }

    public static <F, R> Result<F, R> failure(F error) {
        Objects.requireNonNull(error);
        return new Failed(error);
    }

    public boolean isOK() {
        return false;
    }

    public boolean isFailure() {
        return false;
    }

    public R getResult() {
        throw new NoSuchElementException();
    }

    public F getFailure() {
        throw new NoSuchElementException();
    }

    private static final class Failed<F, R>
    extends Result<F, R> {
        private final F failure;

        Failed(F failure) {
            this.failure = failure;
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public F getFailure() {
            return this.failure;
        }
    }

    private static final class Ok<F, R>
    extends Result<F, R> {
        private final R result;

        Ok(R result) {
            this.result = result;
        }

        @Override
        public boolean isOK() {
            return true;
        }

        @Override
        public R getResult() {
            return this.result;
        }
    }
}

