/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.Consumer;
import driveline.DataRecord;
import driveline.DrivelineClient;
import driveline.DrivelineException;
import driveline.ErrorRecord;
import driveline.RecordHandler;
import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.QueryOptions;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Query
extends Consumer<Query, QueryOptions> {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    final String query;
    private final RecordHandler handler;
    final QueryOptions options;
    private final ThreadPoolExecutor executor;
    private byte[] lastMessageId;
    public final boolean isContinuous;

    Query(DrivelineClient client, int id, String query, boolean isContinuous, QueryOptions options, RecordHandler handler) {
        super(client, id);
        Objects.requireNonNull(query);
        Objects.requireNonNull(options);
        Objects.requireNonNull(handler);
        this.query = query;
        this.isContinuous = isContinuous;
        this.handler = handler;
        this.options = options;
        this.result = this;
        if (options.getConcurrency() == 0) {
            this.executor = null;
        } else {
            this.executor = new ThreadPoolExecutor(0, options.getConcurrency(), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(options.getConcurrency() * 16));
            this.executor.setRejectedExecutionHandler((runnable, executor) -> {
                try {
                    executor.getQueue().put(runnable);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Interrupted while queuing messages ", (Throwable)e);
                }
            });
        }
    }

    @Override
    Consumer handleMessage(DataMessage msg) {
        byte[][] messageIds = msg.getMessageIDs();
        byte[][] messages = msg.messages;
        int count = messages.length;
        if (this.executor == null) {
            if (messageIds != null) {
                for (int i = 0; i < count; ++i) {
                    byte[] messageId = messageIds[i];
                    this.lastMessageId = messageId;
                    this.handler.onRecord(new DataRecord(messages[i], messageId));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    this.handler.onRecord(new DataRecord(messages[i], null));
                }
            }
        } else if (messageIds != null) {
            for (int i = 0; i < count; ++i) {
                byte[] message = messages[i];
                byte[] messageId = messageIds[i];
                this.lastMessageId = messageId;
                this.executor.execute(() -> this.handler.onRecord(new DataRecord(message, messageId)));
            }
        } else {
            for (int i = 0; i < count; ++i) {
                byte[] message = messages[i];
                this.executor.execute(() -> this.handler.onRecord(new DataRecord(message, null)));
            }
        }
        return this;
    }

    @Override
    Consumer handleError(ErrorMessage msg) {
        this.handler.onRecord(new ErrorRecord(msg.message));
        return null;
    }

    @Override
    public void close() throws DrivelineException {
        this.client.cancel(this);
    }

    @Override
    Consumer onReconnect() throws DrivelineException {
        if (this.lastMessageId != null) {
            this.options.fromMessage(this.lastMessageId);
        }
        this.client.query(this);
        return this;
    }

    @Override
    Consumer onDisconnect() {
        return this;
    }

    @Override
    QueryOptions getOptions() {
        return this.options;
    }
}

