/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.Consumer;
import driveline.DrivelineClient;
import driveline.DrivelineException;
import driveline.Result;
import driveline.cbor.CborException;
import driveline.cbor.decoder.CborBuffer;
import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.ListOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ListConsumer
extends Consumer<Iterable<String>, ListOptions> {
    private static final Logger log = LoggerFactory.getLogger(ListConsumer.class);
    private final ListDecoder decoder = new ListDecoder();
    private final LinkedBlockingQueue<Result<Exception, String>> outputQueue = new LinkedBlockingQueue();
    final String pattern;
    private final ListOptions options;
    private boolean isDone;

    ListConsumer(DrivelineClient client, int id, String pattern, ListOptions options) {
        super(client, id);
        this.result = new ListResult(this.outputQueue);
        this.isDone = false;
        this.pattern = pattern;
        this.options = options;
    }

    @Override
    public Consumer handleMessage(DataMessage msg) {
        if (this.isDone) {
            return null;
        }
        try {
            try {
                this.decoder.reset(msg.messages[0], 0, msg.messages[0].length);
                String[] entries = this.decoder.getStreamList();
                int count = entries.length;
                if (count == 0) {
                    this.isDone = true;
                    this.outputQueue.put(Result.failure(new StopIteration()));
                    return null;
                }
                for (int i = 0; i < count; ++i) {
                    String entry = entries[i];
                    this.outputQueue.put(Result.ok(entry));
                }
                return this;
            }
            catch (CborException e) {
                this.outputQueue.put(Result.failure(new DrivelineException("invalid stream name received")));
            }
        }
        catch (InterruptedException e) {
            log.warn("interrupted while adding error to list result");
        }
        this.isDone = true;
        return null;
    }

    @Override
    Consumer handleError(ErrorMessage msg) {
        if (this.isDone) {
            return null;
        }
        this.isDone = true;
        try {
            this.outputQueue.put(Result.failure(new DrivelineException(msg.message)));
        }
        catch (InterruptedException e) {
            log.warn("interrupted while adding error to list result");
        }
        return null;
    }

    @Override
    ListOptions getOptions() {
        return this.options;
    }

    @Override
    Consumer onDisconnect() {
        this.isDone = true;
        try {
            this.outputQueue.put(Result.failure(new DrivelineException("connection lost")));
        }
        catch (InterruptedException e) {
            log.warn("interrupted while adding error to list result");
        }
        return null;
    }

    @Override
    Consumer onReconnect() {
        return null;
    }

    private static final class StopIteration
    extends Exception {
        private StopIteration() {
        }
    }

    private static class ListResult
    implements Iterable<String>,
    Iterator<String> {
        private final BlockingQueue<Result<Exception, String>> list;
        private boolean isDone;
        private Result<Exception, String> next;

        ListResult(BlockingQueue<Result<Exception, String>> list) {
            this.list = list;
            this.isDone = false;
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            if (this.isDone) {
                return false;
            }
            try {
                if (this.next == null) {
                    this.next = this.list.take();
                }
                if (this.next.isOK()) {
                    return true;
                }
                if (this.next.getFailure() instanceof StopIteration) {
                    this.isDone = true;
                    this.next = null;
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                this.isDone = true;
                this.next = null;
                return false;
            }
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                if (this.next.isOK()) {
                    String result = this.next.getResult();
                    this.next = null;
                    return result;
                }
                throw new RuntimeException(this.next.getFailure());
            }
            throw new NoSuchElementException();
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }
    }

    static final class ListDecoder
    extends CborBuffer {
        ListDecoder() {
        }

        String[] getStreamList() throws CborException {
            if ((0xE0 & this.buf[this.offset]) != 128) {
                throw new CborException("Invalid message");
            }
            int entryCount = this.getVarInt32();
            String[] result = new String[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                result[i] = this.getTextString();
            }
            return result;
        }
    }
}

