/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.DrivelineClient;
import driveline.DrivelineException;
import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.ServerMessage;
import java.util.Objects;

abstract class Consumer<T, O> {
    final long consumerId;
    final DrivelineClient client;
    protected T result;

    Consumer(DrivelineClient client, long id) {
        Objects.requireNonNull(client);
        this.client = client;
        this.consumerId = id;
    }

    abstract Consumer handleMessage(DataMessage var1);

    abstract Consumer handleError(ErrorMessage var1);

    abstract Consumer onReconnect() throws DrivelineException;

    abstract Consumer onDisconnect() throws DrivelineException;

    Consumer onMessage(ServerMessage message) {
        if (message.isOK()) {
            return this.handleMessage((DataMessage)message);
        }
        return this.handleError((ErrorMessage)message);
    }

    final T getResult() {
        return this.result;
    }

    abstract O getOptions();

    void close() throws DrivelineException {
    }
}

