/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline.cbor;

public abstract class Cbor {
  public static final int TypeMask = 0b11100000;
  public static final int SizeMask = 0b00011111;

  public static final int UnsignedInteger = 0;
  public static final int NegativeInteger = 1 << 5;
  public static final int ByteString = 2 << 5;
  public static final int TextString = 3 << 5;
  public static final int Array = 4 << 5;
  public static final int Map = 5 << 5;
  public static final int Tag = 6 << 5;
  public static final int Multi = 7 << 5;
  // Extended
  public static final int BooleanEx = 100;
  public static final int NullEx = 101;
  public static final int UndefinedEx = 102;

  // single byte values
  public static final int FALSE = Multi | 20;
  public static final int TRUE = Multi | 21;
  public static final int NULL = Multi | 22;
  public static final int UNDEFINED = Multi | 23;
  public static final int BREAK = Multi | 0x1F;

}
