/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline;

import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class Result<F, R> {

  @SuppressWarnings("WeakerAccess")
  public static <F, R> Result<F, R> ok(final R result) {
    Objects.requireNonNull(result);
    return new Ok<>(result);
  }

  @SuppressWarnings("WeakerAccess")
  public static <F, R> Result<F, R> failure(final F error) {
    Objects.requireNonNull(error);
    return new Failed<>(error);
  }

  public boolean isOK() {
    return false;
  }

  public boolean isFailure() {
    return false;
  }

  public R getResult() {
    throw new NoSuchElementException();
  }

  public F getFailure() {
    throw new NoSuchElementException();
  }

  static private final class Ok<F, R> extends Result<F, R> {
    private final R result;

    Ok(R result) {
      this.result = result;
    }

    @Override
    public boolean isOK() {
      return true;
    }

    @Override
    public R getResult() {
      return result;
    }
  }

  static private final class Failed<F, R> extends Result<F, R> {
    private final F failure;

    Failed(F failure) {
      this.failure = failure;
    }

    @Override
    public boolean isFailure() {
      return true;
    }

    @Override
    public F getFailure() {
      return failure;
    }
  }

}
