/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline;

import java.util.Objects;

import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.ServerMessage;

abstract class Consumer<T, O> {
  final long consumerId;
  final DrivelineClient client;
  protected T result;

  Consumer(DrivelineClient client, long id) {
    Objects.requireNonNull(client);
    this.client = client;
    this.consumerId = id;
  }

  abstract Consumer handleMessage(DataMessage message);

  abstract Consumer handleError(ErrorMessage msg);

  abstract Consumer onReconnect() throws DrivelineException;

  abstract Consumer onDisconnect() throws DrivelineException;

  Consumer onMessage(ServerMessage message) {
    if (message.isOK()) {
      return handleMessage((DataMessage) message);
    } else {
      return handleError((ErrorMessage) message);
    }
  }

  final T getResult() {
    return result;
  }

  abstract O getOptions();

  void close() throws DrivelineException {
  }

}
