/*
 * Decompiled with CFR 0.152.
 */
package driveline.protocol;

import driveline.cbor.encoder.CborEncoder;
import driveline.protocol.CommandOptions;
import java.time.Duration;
import java.time.temporal.TemporalUnit;

public final class StoreOptions
extends CommandOptions {
    private long ttl = -1L;
    private byte[] casID = null;

    public StoreOptions withTTL(long durationInMillisecond) {
        this.ttl = durationInMillisecond;
        return this;
    }

    public StoreOptions withTTL(long value, TemporalUnit unit) {
        this.ttl = Duration.of(value, unit).toMillis();
        return this;
    }

    public StoreOptions withTTL(Duration value) {
        this.ttl = value.toMillis();
        return this;
    }

    public StoreOptions withCasId(byte[] recordId) {
        this.casID = recordId;
        return this;
    }

    @Override
    public void encode(CborEncoder encoder) {
        if (this.ttl == -1L || this.casID == null) {
            encoder.encodeNull();
            return;
        }
        encoder.encodeArray();
        if (this.ttl != -1L) {
            encoder.encode(4L).encode(this.ttl);
        }
        if (this.casID != null) {
            encoder.encode(3L).encode(this.casID);
        }
        encoder.endArray();
    }
}

