/*
 * Decompiled with CFR 0.152.
 */
package driveline.protocol;

import driveline.cbor.encoder.CborEncoder;
import driveline.protocol.CommandOptions;

public final class QueryOptions
extends CommandOptions {
    private byte[] recordId = null;
    private Integer concurrency = null;

    public QueryOptions withConcurrency(int concurrency) {
        if (concurrency < 0) {
            throw new IllegalArgumentException("concurrency must be a positive number");
        }
        this.concurrency = concurrency;
        return this;
    }

    public int getConcurrency() {
        return this.concurrency == null ? 1 : this.concurrency;
    }

    public QueryOptions fromMessage(byte[] messageID) {
        this.recordId = messageID;
        return this;
    }

    @Override
    public void encode(CborEncoder encoder) {
        if (this.recordId != null) {
            encoder.encodeArray().encode(2L).encode(this.recordId).endArray();
        } else {
            encoder.encodeNull();
        }
    }
}

