/*
 * Decompiled with CFR 0.152.
 */
package driveline.cbor.encoder;

import driveline.cbor.encoder.CborDataItem;

public final class CborInteger
extends CborDataItem {
    private final long value;
    private final int sizeInBytes;
    private final boolean isNegative;

    CborInteger(long value) {
        this.isNegative = value < 0L;
        this.value = this.isNegative ? value ^ 0xFFFFFFFFFFFFFFFFL : value;
        this.sizeInBytes = CborInteger.encodedLength(this.value);
    }

    @Override
    public int encodedSize() {
        return this.sizeInBytes;
    }

    @Override
    int encode(byte[] buf, int offset) {
        return CborInteger.encodeTypeAndSize(buf, offset, this.isNegative ? 32 : 0, this.value);
    }
}

