/*
 * Decompiled with CFR 0.152.
 */
package driveline.cbor.encoder;

import driveline.cbor.encoder.CborData;
import driveline.cbor.encoder.CborDataItem;
import driveline.cbor.encoder.CborDataItemContainer;
import driveline.cbor.encoder.CborInteger;
import driveline.cbor.encoder.CborSerializable;
import java.nio.charset.Charset;

public class CborEncoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private CborDataItem[] items = new CborDataItem[8];
    private int itemCount = 0;
    private int[] containers = new int[8];
    private int containerCount = 0;
    private CborDataItemContainer lastContainer = null;

    public CborEncoder encode(CborSerializable item) {
        item.encode(this);
        return this;
    }

    public CborEncoder encodeNullable(CborSerializable item) {
        return item == null ? this.encodeNull() : this.encode(item);
    }

    public CborEncoder encodeArray() {
        this.addDataItemContainer(new CborDataItemContainer(128));
        return this;
    }

    public CborEncoder endArray() {
        return this.endContainer(128);
    }

    public CborEncoder encodeMap() {
        this.addDataItemContainer(new CborDataItemContainer(160));
        return this;
    }

    public CborEncoder endMap() {
        return this.endContainer(160);
    }

    CborEncoder endContainer(int type) {
        if (this.lastContainer == null || this.lastContainer.type != type) {
            throw new IllegalStateException("cannot end '" + (type == 128 ? "array" : "map") + "': no such container");
        }
        if (this.lastContainer.type == 160 && this.lastContainer.itemCount % 2 != 0) {
            throw new IllegalStateException("map does not contain an even number of items (" + this.lastContainer.itemCount + ")");
        }
        --this.containerCount;
        this.lastContainer = this.containerCount == 0 ? null : (CborDataItemContainer)this.items[this.containers[this.containerCount - 1]];
        return this;
    }

    public CborEncoder encode(String value) {
        this.addDataItem(new CborData(96, value.getBytes(UTF8)));
        return this;
    }

    public CborEncoder encode(byte[] value) {
        this.addDataItem(new CborData(64, value));
        return this;
    }

    public CborEncoder encode(long value) {
        this.addDataItem(new CborInteger(value));
        return this;
    }

    public CborEncoder encode(boolean value) {
        this.addDataItem(value ? CborDataItem.True : CborDataItem.False);
        return this;
    }

    public CborEncoder encodeNull() {
        this.addDataItem(CborDataItem.Null);
        return this;
    }

    public CborEncoder encodeUndefined() {
        this.addDataItem(CborDataItem.Undefined);
        return this;
    }

    public byte[] getBytes() {
        int sizeInBytes = 0;
        for (int i = 0; i < this.itemCount; ++i) {
            sizeInBytes += this.items[i].encodedSize();
        }
        byte[] encodedData = new byte[sizeInBytes];
        int offset = 0;
        for (int i = 0; i < this.itemCount; ++i) {
            offset += this.items[i].encode(encodedData, offset);
        }
        return encodedData;
    }

    int addDataItem(CborDataItem item) {
        if (this.lastContainer != null) {
            this.lastContainer.incrementItemCount();
        }
        if (this.itemCount >= this.items.length) {
            CborDataItem[] oldItems = this.items;
            this.items = new CborDataItem[oldItems.length * 2];
            System.arraycopy(oldItems, 0, this.items, 0, this.itemCount);
        }
        this.items[this.itemCount++] = item;
        return this.itemCount - 1;
    }

    int addDataItemContainer(CborDataItemContainer container) {
        int itemIndex = this.addDataItem(container);
        if (this.containerCount >= this.containers.length) {
            int[] oldContainers = this.containers;
            this.containers = new int[this.containers.length * 2];
            System.arraycopy(oldContainers, 0, this.containers, 0, this.containerCount);
        }
        this.containers[this.containerCount++] = itemIndex;
        this.lastContainer = container;
        return itemIndex;
    }

    public static CborEncoder arrayEncoder() {
        return new CborEncoder().encodeArray();
    }

    public static CborEncoder mapEncoder() {
        return new CborEncoder().encodeMap();
    }
}

