/*
 * Decompiled with CFR 0.152.
 */
package driveline.cbor.encoder;

import driveline.cbor.encoder.CborDataItem;

final class CborData
extends CborDataItem {
    private final int type;
    private final byte[] value;
    private final int sizeInBytes;

    CborData(int type, byte[] value) {
        this.type = type;
        this.value = value;
        this.sizeInBytes = value.length + CborData.encodedLength(value.length);
    }

    @Override
    public int encodedSize() {
        return this.sizeInBytes;
    }

    @Override
    public int encode(byte[] buf, int offset) {
        int written = CborData.encodeTypeAndSize(buf, offset, this.type, this.value.length);
        System.arraycopy(this.value, 0, buf, offset + written, this.value.length);
        return written + this.value.length;
    }
}

