/*
 * Decompiled with CFR 0.152.
 */
package driveline.cbor.decoder;

import driveline.cbor.CborException;
import java.nio.charset.Charset;

public class CborBuffer {
    public byte[] buf;
    public int start;
    public int length;
    public int offset;
    private static final String INVALID_SERVER_MESSAGE = "Invalid server message";
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public CborBuffer() {
        this.buf = null;
        this.start = 0;
        this.length = 0;
        this.offset = 0;
    }

    public CborBuffer(byte[] buf, int offset, int length) {
        this.reset(buf, offset, length);
    }

    public final void reset(byte[] buf, int offset, int length) {
        this.buf = buf;
        this.start = offset;
        this.offset = offset;
        this.length = length;
    }

    public int getVarInt8() throws CborException {
        int code;
        if ((code = 0x1F & this.buf[this.offset++]) < 24) {
            return code;
        }
        if (code == 24) {
            return 0xFF & this.buf[this.offset++];
        }
        throw new CborException(INVALID_SERVER_MESSAGE);
    }

    public int getVarInt16() throws CborException {
        int code;
        if ((code = 0x1F & this.buf[this.offset++]) < 24) {
            return code;
        }
        if (code == 24) {
            return 0xFF & this.buf[this.offset++];
        }
        if (code == 25) {
            return (0xFF & this.buf[this.offset++]) << 8 | 0xFF & this.buf[this.offset++];
        }
        throw new CborException(INVALID_SERVER_MESSAGE);
    }

    public int getVarInt32() throws CborException {
        int code;
        if ((code = 0x1F & this.buf[this.offset++]) < 24) {
            return code;
        }
        if (code == 24) {
            return 0xFF & this.buf[this.offset++];
        }
        if (code == 25) {
            return (0xFF & this.buf[this.offset++]) << 8 | 0xFF & this.buf[this.offset++];
        }
        if (code == 26) {
            return (0xFF & this.buf[this.offset++]) << 24 | (0xFF & this.buf[this.offset++]) << 16 | (0xFF & this.buf[this.offset++]) << 8 | 0xFF & this.buf[this.offset++];
        }
        throw new CborException(INVALID_SERVER_MESSAGE);
    }

    public long getVarInt64() throws CborException {
        long code;
        if ((code = (long)(0x1F & this.buf[this.offset++])) < 24L) {
            return code;
        }
        if (code == 24L) {
            return 0xFFL & (long)this.buf[this.offset++];
        }
        if (code == 25L) {
            return (0xFFL & (long)this.buf[this.offset++]) << 8 | 0xFFL & (long)this.buf[this.offset++];
        }
        if (code == 26L) {
            return (0xFFL & (long)this.buf[this.offset++]) << 24 | (0xFFL & (long)this.buf[this.offset++]) << 16 | (0xFFL & (long)this.buf[this.offset++]) << 8 | 0xFFL & (long)this.buf[this.offset++];
        }
        if (code == 27L) {
            return (0xFFL & (long)this.buf[this.offset++]) << 56 | (0xFFL & (long)this.buf[this.offset++]) << 48 | (0xFFL & (long)this.buf[this.offset++]) << 40 | (0xFFL & (long)this.buf[this.offset++]) << 32 | (0xFFL & (long)this.buf[this.offset++]) << 24 | (0xFFL & (long)this.buf[this.offset++]) << 16 | (0xFFL & (long)this.buf[this.offset++]) << 8 | 0xFFL & (long)this.buf[this.offset++];
        }
        throw new CborException(INVALID_SERVER_MESSAGE);
    }

    public String getTextString() throws CborException {
        if ((0xE0 & this.buf[this.offset]) != 96) {
            throw new CborException(INVALID_SERVER_MESSAGE);
        }
        long length = this.getVarInt32();
        String result = new String(this.buf, this.offset, (int)length, UTF8);
        this.offset = (int)((long)this.offset + length);
        return result;
    }

    public byte[] getByteString() throws CborException {
        if ((0xE0 & this.buf[this.offset]) != 64) {
            throw new CborException(INVALID_SERVER_MESSAGE);
        }
        int length = this.getVarInt32();
        byte[] result = new byte[length];
        System.arraycopy(this.buf, this.offset, result, 0, length);
        this.offset += length;
        return result;
    }
}

