/*
 * Decompiled with CFR 0.152.
 */
package driveline;

import driveline.Consumer;
import driveline.DataRecord;
import driveline.DrivelineClient;
import driveline.DrivelineException;
import driveline.Record;
import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.LoadOptions;
import java.util.concurrent.CompletableFuture;

final class LoadConsumer
extends Consumer<CompletableFuture<Record>, LoadOptions> {
    final String keyName;
    private final LoadOptions options;

    LoadConsumer(DrivelineClient client, int consumerId, String keyName, LoadOptions options) {
        super(client, consumerId);
        this.result = new CompletableFuture();
        this.keyName = keyName;
        this.options = options;
    }

    @Override
    Consumer handleMessage(DataMessage msg) {
        ((CompletableFuture)this.result).complete(new DataRecord(msg.messages[0]));
        return null;
    }

    @Override
    Consumer handleError(ErrorMessage m) {
        ((CompletableFuture)this.result).completeExceptionally(new DrivelineException(m.message));
        return null;
    }

    @Override
    Consumer onReconnect() throws DrivelineException {
        this.client.load(this);
        return this;
    }

    @Override
    Consumer onDisconnect() {
        return this;
    }

    @Override
    LoadOptions getOptions() {
        return this.options;
    }
}

