/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline.protocol;

import driveline.cbor.encoder.CborEncoder;

public final class QueryOptions extends CommandOptions {
  private byte[] recordId;
  private Integer concurrency;

  public QueryOptions() {
    recordId = null;
    concurrency = null;
  }

  public QueryOptions withConcurrency(int concurrency) {
    if (concurrency < 0) {
      throw new IllegalArgumentException("concurrency must be a positive number");
    }
    this.concurrency = concurrency;
    return this;
  }

  public int getConcurrency() {
    return concurrency == null ? 1 : concurrency;
  }

  public QueryOptions fromMessage(byte[] messageID) {
    this.recordId = messageID;
    return this;
  }

  @Override
  public void encode(CborEncoder encoder) {
    if (recordId != null) {
      encoder.encodeArray().encode(TagId.READ_ID).encode(recordId).endArray();
    } else {
      encoder.encodeNull();
    }
  }
}
