/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline;

import java.util.Collection;
import java.util.Objects;

import driveline.protocol.AppendOptions;

@SuppressWarnings({"unused", "WeakerAccess"})
public class Stream {
  final StreamId streamId;
  private final DrivelineClient client;

  Stream(DrivelineClient client, StreamId streamId) {
    Objects.requireNonNull(client);
    Objects.requireNonNull(streamId);
    this.client = client;
    this.streamId = streamId;
  }

  public void append(byte[] data) throws DrivelineException {
    client.append(streamId, data, new AppendOptions());
  }

  public void append(byte[] data, AppendOptions options) throws DrivelineException {
    client.append(streamId, data, options);
  }

  public void append(Collection<byte[]> messages) throws DrivelineException {
    append(messages, new AppendOptions());
  }

  public void append(Collection<byte[]> messages, AppendOptions options) throws DrivelineException {
    for (byte[] message : messages) {
      client.append(streamId, message, options);
    }
  }

  public void truncate() throws DrivelineException {
    client.truncate(streamId);
  }

  public void close() {
    client.closeStream(this);
  }

}

