/*
 * Copyright 2019, 1533 Systems, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package driveline;

import java.util.concurrent.CompletableFuture;

import driveline.protocol.DataMessage;
import driveline.protocol.ErrorMessage;
import driveline.protocol.LoadOptions;

final class LoadConsumer extends Consumer<CompletableFuture<Record>, LoadOptions> {

  final String keyName;
  private final LoadOptions options;

  LoadConsumer(DrivelineClient client, int consumerId, String keyName, LoadOptions options) {
    super(client, consumerId);

    this.result = new CompletableFuture<>();
    this.keyName = keyName;
    this.options = options;
  }

  @Override
  Consumer handleMessage(DataMessage msg) {
    result.complete(new DataRecord(msg.messages[0]));
    return null;
  }

  @Override
  Consumer handleError(ErrorMessage m) {
    result.completeExceptionally(new DrivelineException(m.message));
    return null;
  }

  @Override
  Consumer onReconnect() throws DrivelineException {
    client.load(this);
    return this;
  }

  @Override
  Consumer onDisconnect() {
    return this;
  }

  @Override
  LoadOptions getOptions() {
    return options;
  }
}
