/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.util;

import com.atlassian.maven.plugins.jgitflow.PrettyPrompter;
import com.google.common.base.Strings;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ConsoleCredentialsProvider
extends CredentialsProvider {
    private PrettyPrompter prompter;
    private String userName;
    private String password;

    public ConsoleCredentialsProvider(PrettyPrompter prompter) {
        this.prompter = prompter;
    }

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.StringType || i instanceof CredentialItem.CharArrayType || i instanceof CredentialItem.YesNoType || i instanceof CredentialItem.InformationalMessage) continue;
            return false;
        }
        return true;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        boolean ok = true;
        for (CredentialItem item : items) {
            if (item instanceof CredentialItem.StringType) {
                ok = this.get((CredentialItem.StringType)item);
                continue;
            }
            if (item instanceof CredentialItem.CharArrayType) {
                ok = this.get((CredentialItem.CharArrayType)item);
                continue;
            }
            if (item instanceof CredentialItem.InformationalMessage) {
                ok = this.get((CredentialItem.InformationalMessage)item);
                continue;
            }
            throw new UnsupportedCredentialItem(uri, item.getPromptText());
        }
        return ok;
    }

    private boolean get(CredentialItem.StringType item) {
        if (item.isValueSecure()) {
            String v = this.askPassword(item.getPromptText());
            if (v != null) {
                item.setValue(v);
                return true;
            }
            return false;
        }
        String v = this.askUser(item.getPromptText());
        if (v != null) {
            item.setValue(v);
            return true;
        }
        return false;
    }

    private boolean get(CredentialItem.CharArrayType item) {
        if (item.isValueSecure()) {
            String v = this.askPassword(item.getPromptText());
            if (v != null) {
                item.setValue(v.toCharArray());
                return true;
            }
            return false;
        }
        String v = this.askUser(item.getPromptText());
        if (v != null) {
            item.setValue(v.toCharArray());
            return true;
        }
        return false;
    }

    private boolean get(CredentialItem.InformationalMessage item) {
        try {
            this.prompter.promptForPassword(item.getPromptText());
        }
        catch (PrompterException e) {
            e.printStackTrace();
        }
        return true;
    }

    private String askPassword(String prompted) {
        try {
            if (this.password == null) {
                this.password = Strings.emptyToNull((String)this.prompter.promptForPassword(prompted));
            }
            return this.password;
        }
        catch (PrompterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String askUser(String prompted) {
        try {
            if (this.userName == null) {
                this.userName = Strings.emptyToNull((String)this.prompter.prompt(prompted));
            }
            return this.userName;
        }
        catch (PrompterException e) {
            e.printStackTrace();
            return null;
        }
    }
}

