/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.provider;

import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.maven.plugins.jgitflow.PrettyPrompter;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.VersionState;
import com.atlassian.maven.plugins.jgitflow.VersionType;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.helper.MavenExecutionHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.atlassian.maven.plugins.jgitflow.provider.MavenSessionProvider;
import com.atlassian.maven.plugins.jgitflow.provider.ProjectCacheKey;
import com.atlassian.maven.plugins.jgitflow.provider.VersionProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.apache.maven.shared.release.version.HotfixVersionInfo;
import org.apache.maven.shared.release.versions.DefaultVersionInfo;
import org.apache.maven.shared.release.versions.VersionInfo;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=VersionProvider.class)
public class DefaultVersionProvider
extends AbstractLogEnabled
implements VersionProvider {
    private final Map<ProjectCacheKey, Map<String, String>> nextReleaseVersions = new HashMap<ProjectCacheKey, Map<String, String>>();
    private final Map<ProjectCacheKey, Map<String, String>> nextDevelopmentVersions = new HashMap<ProjectCacheKey, Map<String, String>>();
    private final Map<ProjectCacheKey, Map<String, String>> nextHotfixVersions = new HashMap<ProjectCacheKey, Map<String, String>>();
    private final Map<ProjectCacheKey, Map<String, String>> lastReleaseVersions = new HashMap<ProjectCacheKey, Map<String, String>>();
    private final Map<ProjectCacheKey, Map<String, String>> originalVersions = new HashMap<ProjectCacheKey, Map<String, String>>();
    @Requirement
    private PrettyPrompter prompter;
    @Requirement
    private MavenExecutionHelper mavenHelper;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private MavenSessionProvider sessionProvider;

    @Override
    public Map<String, String> getOriginalVersions(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) {
        if (!this.originalVersions.containsKey((Object)cacheKey)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            for (MavenProject project : reactorProjects) {
                versions.put(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()), project.getVersion());
            }
            this.originalVersions.put(cacheKey, versions);
        }
        return ImmutableMap.copyOf(this.originalVersions.get((Object)cacheKey));
    }

    @Override
    public Map<String, String> getOriginalVersions(List<MavenProject> reactorProjects) {
        HashMap<String, String> versions = new HashMap<String, String>();
        for (MavenProject project : reactorProjects) {
            versions.put(ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()), project.getVersion());
        }
        return ImmutableMap.copyOf(versions);
    }

    @Override
    public String getRootVersion(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) {
        if (reactorProjects.size() < 1) {
            return "";
        }
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        return this.getOriginalVersions(cacheKey, reactorProjects).get(ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId()));
    }

    @Override
    public String getRootVersion(List<MavenProject> reactorProjects) {
        if (reactorProjects.size() < 1) {
            return "";
        }
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        return this.getOriginalVersions(reactorProjects).get(ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId()));
    }

    @Override
    public Map<String, String> getNextVersionsForType(VersionType versionType, ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        Map<String, String> versions = new HashMap<String, String>();
        switch (versionType) {
            case RELEASE: {
                versions = this.getNextReleaseVersions(cacheKey, reactorProjects);
                break;
            }
            case DEVELOPMENT: {
                versions = this.getNextDevelopmentVersions(cacheKey, reactorProjects);
                break;
            }
            case HOTFIX: {
                versions = this.getNextHotfixVersions(cacheKey, reactorProjects);
            }
        }
        return versions;
    }

    @Override
    public Map<String, String> getNextReleaseVersions(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        return this.getNextVersions(VersionType.RELEASE, cacheKey, reactorProjects, rootProject, ctx.getDefaultReleaseVersion());
    }

    @Override
    public Map<String, String> getNextDevelopmentVersions(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        return this.getNextVersions(VersionType.DEVELOPMENT, cacheKey, reactorProjects, rootProject, ctx.getDefaultDevelopmentVersion());
    }

    @Override
    public Map<String, String> getNextHotfixVersions(ProjectCacheKey cacheKey, List<MavenProject> reactorProjects) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        MavenProject rootProject = ReleaseUtil.getRootProject(reactorProjects);
        return this.getNextVersions(VersionType.HOTFIX, cacheKey, reactorProjects, rootProject, ctx.getDefaultReleaseVersion());
    }

    private Map<String, String> getNextVersions(VersionType versionType, ProjectCacheKey cacheKey, List<MavenProject> reactorProjects, MavenProject rootProject, String contextVersion) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        String promptLabel = versionType.name().toLowerCase();
        Map<ProjectCacheKey, Map<String, String>> cache = null;
        VersionState versionState = null;
        boolean doAutoVersion = true;
        switch (versionType) {
            case RELEASE: {
                cache = this.nextReleaseVersions;
                doAutoVersion = ctx.isAutoVersionSubmodules() && ArtifactUtils.isSnapshot((String)rootProject.getVersion());
                versionState = VersionState.RELEASE;
                break;
            }
            case DEVELOPMENT: {
                cache = this.nextDevelopmentVersions;
                doAutoVersion = ctx.isAutoVersionSubmodules();
                versionState = VersionState.SNAPSHOT;
                break;
            }
            case HOTFIX: {
                cache = this.nextHotfixVersions;
                doAutoVersion = ctx.isAutoVersionSubmodules();
                versionState = VersionState.RELEASE;
            }
        }
        Preconditions.checkNotNull(cache);
        Preconditions.checkNotNull(versionState);
        if (!cache.containsKey((Object)cacheKey)) {
            HashMap<String, String> versions = new HashMap<String, String>();
            if (doAutoVersion) {
                String rootProjectId = ArtifactUtils.versionlessKey((String)rootProject.getGroupId(), (String)rootProject.getArtifactId());
                String rootVersion = this.getNextVersion(versionState, versionType, rootProject, rootProject, contextVersion, promptLabel);
                versions.put(rootProjectId, rootVersion);
                for (MavenProject subProject : reactorProjects) {
                    String subProjectId = ArtifactUtils.versionlessKey((String)subProject.getGroupId(), (String)subProject.getArtifactId());
                    versions.put(subProjectId, rootVersion);
                }
            } else {
                for (MavenProject project : reactorProjects) {
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    String moduleVersion = this.getNextVersion(versionState, versionType, rootProject, project, contextVersion, promptLabel);
                    versions.put(projectId, moduleVersion);
                }
            }
            cache.put(cacheKey, versions);
        }
        return ImmutableMap.copyOf(cache.get((Object)cacheKey));
    }

    @Override
    public Map<String, String> getLastReleaseVersions(MavenProject rootProject) throws MavenJGitFlowException {
        if (!this.lastReleaseVersions.containsKey((Object)ProjectCacheKey.MASTER_BRANCH)) {
            try {
                HashMap<String, String> versions = new HashMap<String, String>();
                JGitFlow flow = this.jGitFlowProvider.gitFlow();
                MavenSession masterSession = this.mavenHelper.getSessionForBranch(flow.getMasterBranchName(), rootProject, this.sessionProvider.getSession());
                List masterProjects = masterSession.getSortedProjects();
                for (MavenProject project : masterProjects) {
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    versions.put(projectId, project.getVersion());
                }
                this.lastReleaseVersions.put(ProjectCacheKey.MASTER_BRANCH, versions);
            }
            catch (Exception e) {
                throw new MavenJGitFlowException("Error getting release versions from master", e);
            }
        }
        return this.lastReleaseVersions.get((Object)ProjectCacheKey.MASTER_BRANCH);
    }

    protected String getNextVersion(VersionState state, VersionType versionType, MavenProject rootProject, MavenProject project, String contextVersion, String promptLabel) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        String defaultVersion = null;
        if (StringUtils.isNotBlank((String)contextVersion)) {
            defaultVersion = contextVersion;
        }
        String finalVersion = defaultVersion;
        while (StringUtils.isBlank((String)finalVersion) || VersionState.RELEASE.equals((Object)state) && ArtifactUtils.isSnapshot((String)finalVersion) || VersionState.SNAPSHOT.equals((Object)state) && !ArtifactUtils.isSnapshot((String)finalVersion)) {
            String suggestedVersion;
            if (VersionType.HOTFIX.equals((Object)versionType)) {
                String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                String lastReleaseVersion = this.getLastReleaseVersions(rootProject).get(projectId);
                suggestedVersion = this.getSuggestedHotfixVersion(project, lastReleaseVersion);
            } else {
                String baseVersion = null;
                if (VersionType.DEVELOPMENT.equals((Object)versionType) && this.nextReleaseVersions.containsKey((Object)ProjectCacheKey.RELEASE_START_LABEL)) {
                    Map<String, String> versionCache = this.nextReleaseVersions.get((Object)ProjectCacheKey.RELEASE_START_LABEL);
                    String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
                    baseVersion = versionCache.get(projectId);
                }
                if (baseVersion == null) {
                    baseVersion = project.getVersion();
                }
                suggestedVersion = this.getSuggestedVersion(versionType, baseVersion);
            }
            if (ctx.isInteractive()) {
                String message = MessageFormat.format("What is the " + promptLabel + " version for \"{0}\"? ({1})", project.getName(), ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId()));
                try {
                    finalVersion = this.prompter.promptNotBlank(message, suggestedVersion);
                    continue;
                }
                catch (PrompterException e) {
                    throw new MavenJGitFlowException("Error reading version from command line " + e.getMessage(), e);
                }
            }
            finalVersion = suggestedVersion;
        }
        return finalVersion;
    }

    private String getSuggestedVersion(VersionType versionType, String incomingVersion) throws MavenJGitFlowException {
        DefaultVersionInfo info;
        ReleaseContext ctx = this.contextProvider.getContext();
        String suggestedVersion = "unknown";
        try {
            info = new DefaultVersionInfo(incomingVersion);
        }
        catch (VersionParseException e) {
            if (ctx.isInteractive()) {
                try {
                    info = new DefaultVersionInfo("1.0");
                }
                catch (VersionParseException e1) {
                    throw new MavenJGitFlowException("error parsing 1.0 version!!!", e1);
                }
            }
            throw new MavenJGitFlowException("error parsing version: " + e.getMessage(), e);
        }
        if (VersionType.RELEASE.equals((Object)versionType)) {
            suggestedVersion = info.getReleaseVersionString();
        } else if (VersionType.DEVELOPMENT.equals((Object)versionType)) {
            suggestedVersion = info.getNextVersion().getSnapshotVersionString();
        }
        return suggestedVersion;
    }

    private String getSuggestedHotfixVersion(MavenProject rootProject, String lastRelease) throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        String suggestedVersion = "unknown";
        String defaultVersion = rootProject.getVersion();
        if (StringUtils.isNotBlank((String)ctx.getDefaultReleaseVersion())) {
            defaultVersion = ctx.getDefaultReleaseVersion();
        }
        if (StringUtils.isNotBlank((String)lastRelease) && !ArtifactUtils.isSnapshot((String)lastRelease)) {
            try {
                DefaultVersionInfo defaultInfo = new DefaultVersionInfo(defaultVersion);
                DefaultVersionInfo lastReleaseInfo = new DefaultVersionInfo(lastRelease);
                String higherVersion = defaultVersion;
                if (defaultInfo.isSnapshot()) {
                    higherVersion = lastRelease;
                } else if (defaultInfo.compareTo((VersionInfo)lastReleaseInfo) < 1) {
                    higherVersion = lastRelease;
                }
                HotfixVersionInfo hotfixInfo = new HotfixVersionInfo(higherVersion);
                suggestedVersion = hotfixInfo.getHotfixVersionString();
            }
            catch (VersionParseException defaultInfo) {}
        } else {
            try {
                HotfixVersionInfo hotfixInfo = new HotfixVersionInfo(defaultVersion);
                suggestedVersion = hotfixInfo.getHotfixVersionString();
            }
            catch (VersionParseException hotfixInfo) {
                // empty catch block
            }
        }
        while (StringUtils.isBlank((String)suggestedVersion) || ArtifactUtils.isSnapshot((String)suggestedVersion)) {
            HotfixVersionInfo info = null;
            try {
                info = new HotfixVersionInfo(defaultVersion);
            }
            catch (VersionParseException e) {
                if (ctx.isInteractive()) {
                    try {
                        info = new HotfixVersionInfo("2.0");
                    }
                    catch (VersionParseException e1) {
                        throw new MavenJGitFlowException("error parsing 2.0 version!!!", e1);
                    }
                }
                throw new MavenJGitFlowException("error parsing release version: " + e.getMessage(), e);
            }
            suggestedVersion = info.getDecrementedHotfixVersionString();
        }
        return suggestedVersion;
    }
}

