/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.jgitflow.api.example;

import com.atlassian.jgitflow.core.JGitFlowInfo;
import com.atlassian.maven.jgitflow.api.exception.MavenJGitFlowExtensionException;
import com.atlassian.maven.jgitflow.api.impl.NoopMavenReleaseFinishExtension;
import com.atlassian.maven.jgitflow.api.util.JGitFlowCommitHelper;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.eclipse.jgit.api.Git;

public class UpdateReadmeExtension
extends NoopMavenReleaseFinishExtension {
    public static final String README_MD = "README.md";

    @Override
    public void onMasterBranchVersionChange(String newVersion, String oldVersion, JGitFlowInfo flow) throws MavenJGitFlowExtensionException {
        try {
            Git git = flow.git();
            File readmeFile = new File(flow.getProjectRoot(), README_MD);
            String readmeContent = Files.toString((File)readmeFile, (Charset)Charsets.UTF_8);
            String newContent = readmeContent.replace(oldVersion, newVersion);
            Files.write((CharSequence)newContent, (File)readmeFile, (Charset)Charsets.UTF_8);
            JGitFlowCommitHelper.commitAllChanges(flow, "updating version in README.md");
        }
        catch (Exception e) {
            throw new MavenJGitFlowExtensionException("Error updating README.md file!", e);
        }
    }
}

