/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow;

import com.atlassian.jgitflow.core.JGitFlowInfo;
import com.atlassian.maven.jgitflow.api.exception.MavenJGitFlowExtensionException;
import com.atlassian.maven.jgitflow.api.impl.NoopMavenReleaseFinishExtension;
import com.atlassian.maven.jgitflow.api.util.JGitFlowCommitHelper;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.Git;

public class ITFinishExtension
extends NoopMavenReleaseFinishExtension {
    public static final String EXTENSION_RESULT = "ext-result.txt";

    public void onMasterBranchVersionChange(String newVersion, String oldVersion, JGitFlowInfo flow) throws MavenJGitFlowExtensionException {
        try {
            Git git = flow.git();
            File extFile = new File(flow.getProjectRoot(), EXTENSION_RESULT);
            if (!extFile.exists()) {
                FileUtils.touch((File)extFile);
            }
            FileUtils.writeStringToFile((File)extFile, (String)(oldVersion + ":" + newVersion));
            JGitFlowCommitHelper.commitAllChanges((JGitFlowInfo)flow, (String)"updating version in extension file");
        }
        catch (Exception e) {
            throw new MavenJGitFlowExtensionException("Error updating ext-result.txt file!", (Throwable)e);
        }
    }
}

