/*
 * Decompiled with CFR 0.152.
 */
package cl.emilym.contrastaccessibility;

import cl.emilym.contrastaccessibility.ContrastAccessibilityContext;

public class ContrastAccessibility {
    private static final int CHANNEL_MASK = 255;
    private static final int RED_SHIFT = 16;
    private static final int GREEN_SHIFT = 8;
    private static final int BLUE_SHIFT = 0;
    private static final double DOUBLE_DENOMINATOR = 255.0;

    private ContrastAccessibility() {
    }

    public static boolean valid(long color1, long color2) {
        return ContrastAccessibility.valid(color1, color2, ContrastAccessibilityContext.TEXT);
    }

    public static boolean valid(long color1, long color2, ContrastAccessibilityContext context) {
        return ContrastAccessibility.ratio(color1, color2) > context.getThreshold();
    }

    public static double ratio(long color1, long color2) {
        double luminance2;
        double luminance1 = ContrastAccessibility.luminance(color1) + 0.05;
        if (luminance1 > (luminance2 = ContrastAccessibility.luminance(color2) + 0.05)) {
            return luminance1 / luminance2;
        }
        return luminance2 / luminance1;
    }

    public static double luminance(long color) {
        double[] channels = new double[]{(double)(color >> 16 & 0xFFL) / 255.0, (double)(color >> 8 & 0xFFL) / 255.0, (double)(color >> 0 & 0xFFL) / 255.0};
        for (int i = 0; i < channels.length; ++i) {
            double channel = channels[i];
            if (channel < 0.04045) {
                int n = i;
                channels[n] = channels[n] / 12.92;
                continue;
            }
            channels[i] = Math.pow((channel + 0.055) / 1.055, 2.4);
        }
        return 0.2126 * channels[0] + 0.7152 * channels[1] + 0.0722 * channels[2];
    }
}

