/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.model;

import java.util.Arrays;
import java.util.stream.Collectors;

public final class JSurbtcException
extends Exception {
    public final int httpStatusCode;
    public final String message;
    public final String code;
    public final Detail[] details;

    public JSurbtcException() {
        this.httpStatusCode = 0;
        this.message = "";
        this.code = "";
        this.details = new Detail[0];
    }

    public JSurbtcException(String message) {
        super(message);
        this.httpStatusCode = 0;
        this.message = message;
        this.code = "";
        this.details = new Detail[0];
    }

    public JSurbtcException(int httpStatusCode, String message, String code, Detail[] details) {
        super(JSurbtcException.message(httpStatusCode, message, code, details));
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.code = code;
        this.details = details;
    }

    public JSurbtcException(int httpStatusCode, Throwable cause, String message, String code, Detail[] details) {
        super(JSurbtcException.message(httpStatusCode, message, code, details), cause);
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.code = code;
        this.details = details;
    }

    public JSurbtcException(int httpStatusCode, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String message, String code, Detail[] details) {
        super(JSurbtcException.message(httpStatusCode, message, code, details), cause, enableSuppression, writableStackTrace);
        this.httpStatusCode = httpStatusCode;
        this.message = message;
        this.code = code;
        this.details = details;
    }

    private static String message(int httpStatusCode, String message, String code, Detail[] details) {
        String detailsString = Arrays.stream(details).map(Object::toString).map(str -> " - " + str).collect(Collectors.joining("\n"));
        String template = "Surbtc request failed. %n HTTP Status Code: %d,%n Message: '%s',%n Code: '%s',%n Details:%n%s";
        return String.format(template, httpStatusCode, message, code, detailsString);
    }

    public static class Detail {
        public final String resource;
        public final String field;
        public final String code;
        public final String message;

        public Detail(String resource, String field, String code, String message) {
            this.resource = resource;
            this.field = field;
            this.code = code;
            this.message = message;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Detail{");
            sb.append("resource='").append(this.resource).append('\'');
            sb.append(", field='").append(this.field).append('\'');
            sb.append(", code='").append(this.code).append('\'');
            sb.append(", message='").append(this.message).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

