/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson.model.market;

import cl.daplay.jsurbtc.jackson.model.JacksonAmount;
import cl.daplay.jsurbtc.model.Market;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;

public class JacksonMarket
implements Market,
Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="base_currency")
    private final String baseCurrency;
    @JsonProperty(value="quote_currency")
    private final String quoteCurrency;
    @JsonProperty(value="minimum_order_amount")
    private final JacksonAmount minimumOrderAmount;

    @JsonCreator
    public JacksonMarket(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="base_currency") String baseCurrency, @JsonProperty(value="quote_currency") String quoteCurrency, @JsonProperty(value="minimum_order_amount") JacksonAmount minimumOrderAmount) {
        this.id = id;
        this.name = name;
        this.baseCurrency = baseCurrency;
        this.quoteCurrency = quoteCurrency;
        this.minimumOrderAmount = minimumOrderAmount;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    @Override
    public String getQuoteCurrency() {
        return this.quoteCurrency;
    }

    @Override
    public BigDecimal getMinimumOrderAmount() {
        return this.minimumOrderAmount.getAmount();
    }

    @Override
    public String getMinimumOrderAmountCurrency() {
        return this.minimumOrderAmount.getCurrency();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonMarket market = (JacksonMarket)o;
        if (this.id != null ? !this.id.equals(market.id) : market.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(market.name) : market.name != null) {
            return false;
        }
        if (this.baseCurrency != null ? !this.baseCurrency.equals(market.baseCurrency) : market.baseCurrency != null) {
            return false;
        }
        if (this.quoteCurrency != null ? !this.quoteCurrency.equals(market.quoteCurrency) : market.quoteCurrency != null) {
            return false;
        }
        return this.minimumOrderAmount != null ? this.minimumOrderAmount.equals(market.minimumOrderAmount) : market.minimumOrderAmount == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.baseCurrency != null ? this.baseCurrency.hashCode() : 0);
        result = 31 * result + (this.quoteCurrency != null ? this.quoteCurrency.hashCode() : 0);
        result = 31 * result + (this.minimumOrderAmount != null ? this.minimumOrderAmount.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Market{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", baseCurrency='" + this.baseCurrency + '\'' + ", quoteCurrency='" + this.quoteCurrency + '\'' + ", minimumOrderAmount=" + this.minimumOrderAmount + '}';
    }
}

