/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson.model.balance;

import cl.daplay.jsurbtc.jackson.model.JacksonAmount;
import cl.daplay.jsurbtc.model.Balance;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.math.BigDecimal;

@JsonPropertyOrder(value={"id", "amount", "available_amount", "frozen_amount", "pending_withdraw_amount", "account_id"})
public class JacksonBalance
implements Balance,
Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="account_id")
    private final long accountId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="amount")
    private final JacksonAmount amount;
    @JsonProperty(value="available_amount")
    private final JacksonAmount availableAmount;
    @JsonProperty(value="frozen_amount")
    private final JacksonAmount frozenAmount;
    @JsonProperty(value="pending_withdraw_amount")
    private final JacksonAmount pendingWithdrawAmount;

    @JsonCreator
    public JacksonBalance(@JsonProperty(value="account_id") long accountId, @JsonProperty(value="id") String id, @JsonProperty(value="amount") JacksonAmount amount, @JsonProperty(value="available_amount") JacksonAmount availableAmount, @JsonProperty(value="frozen_amount") JacksonAmount frozenAmount, @JsonProperty(value="pending_withdraw_amount") JacksonAmount pendingWithdrawAmount) {
        this.accountId = accountId;
        this.id = id;
        this.amount = amount;
        this.availableAmount = availableAmount;
        this.frozenAmount = frozenAmount;
        this.pendingWithdrawAmount = pendingWithdrawAmount;
    }

    @Override
    public long getAccountId() {
        return this.accountId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount.getAmount();
    }

    @Override
    public String getAmountCurrency() {
        return this.amount.getCurrency();
    }

    @Override
    public BigDecimal getAvailableAmount() {
        return this.availableAmount.getAmount();
    }

    @Override
    public String getAvailableAmountCurrency() {
        return this.availableAmount.getCurrency();
    }

    @Override
    public BigDecimal getFrozenAmount() {
        return this.frozenAmount.getAmount();
    }

    @Override
    public String getFrozenAmountCurrency() {
        return this.frozenAmount.getCurrency();
    }

    @Override
    public BigDecimal getPendingWithdrawAmount() {
        return this.pendingWithdrawAmount.getAmount();
    }

    @Override
    public String getPendingWithdrawAmountCurrency() {
        return this.pendingWithdrawAmount.getCurrency();
    }

    public String toString() {
        return "Balance{accountId=" + this.accountId + ", id='" + this.id + '\'' + ", amount=" + this.amount + ", availableAmount=" + this.availableAmount + ", frozenAmount=" + this.frozenAmount + ", pendingWithdrawAmount=" + this.pendingWithdrawAmount + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonBalance balance = (JacksonBalance)o;
        if (this.accountId != balance.accountId) {
            return false;
        }
        if (this.id != null ? !this.id.equals(balance.id) : balance.id != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(balance.amount) : balance.amount != null) {
            return false;
        }
        if (this.availableAmount != null ? !this.availableAmount.equals(balance.availableAmount) : balance.availableAmount != null) {
            return false;
        }
        if (this.frozenAmount != null ? !this.frozenAmount.equals(balance.frozenAmount) : balance.frozenAmount != null) {
            return false;
        }
        return this.pendingWithdrawAmount != null ? this.pendingWithdrawAmount.equals(balance.pendingWithdrawAmount) : balance.pendingWithdrawAmount == null;
    }

    public int hashCode() {
        int result = (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.availableAmount != null ? this.availableAmount.hashCode() : 0);
        result = 31 * result + (this.frozenAmount != null ? this.frozenAmount.hashCode() : 0);
        result = 31 * result + (this.pendingWithdrawAmount != null ? this.pendingWithdrawAmount.hashCode() : 0);
        return result;
    }
}

