/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson.model;

import cl.daplay.jsurbtc.jackson.BigDecimalToStringSerializer;
import cl.daplay.jsurbtc.jackson.model.JacksonAmount;
import cl.daplay.jsurbtc.model.Ticker;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;

public class JacksonTicker
implements Ticker,
Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="last_price")
    private final JacksonAmount lastPrice;
    @JsonProperty(value="min_ask")
    private final JacksonAmount minAsk;
    @JsonProperty(value="max_bid")
    private final JacksonAmount maxBid;
    @JsonProperty(value="volume")
    private final JacksonAmount volume;
    @JsonProperty(value="price_variation_24h")
    @JsonSerialize(using=BigDecimalToStringSerializer.class)
    private final BigDecimal priceVariation24Hours;
    @JsonProperty(value="price_variation_7d")
    @JsonSerialize(using=BigDecimalToStringSerializer.class)
    private final BigDecimal priceVariation7Days;

    @JsonCreator
    public JacksonTicker(@JsonProperty(value="last_price") JacksonAmount lastPrice, @JsonProperty(value="min_ask") JacksonAmount minAsk, @JsonProperty(value="max_bid") JacksonAmount maxBid, @JsonProperty(value="volume") JacksonAmount volume, @JsonProperty(value="price_variation_24h") BigDecimal priceVariation24Hours, @JsonProperty(value="price_variation_7d") BigDecimal priceVariation7Days) {
        this.lastPrice = lastPrice;
        this.minAsk = minAsk;
        this.maxBid = maxBid;
        this.volume = volume;
        this.priceVariation24Hours = priceVariation24Hours;
        this.priceVariation7Days = priceVariation7Days;
    }

    @Override
    public BigDecimal getLastPrice() {
        return this.lastPrice.getAmount();
    }

    @Override
    public String getLastPriceCurrency() {
        return this.lastPrice.getCurrency();
    }

    @Override
    public BigDecimal getMinAsk() {
        return this.minAsk.getAmount();
    }

    @Override
    public String getMinAskCurrency() {
        return this.minAsk.getCurrency();
    }

    @Override
    public BigDecimal getMaxBid() {
        return this.maxBid.getAmount();
    }

    @Override
    public String getMaxBidCurrency() {
        return this.maxBid.getCurrency();
    }

    @Override
    public BigDecimal getVolume() {
        return this.volume.getAmount();
    }

    @Override
    public String getVolumeCurrency() {
        return this.volume.getCurrency();
    }

    @Override
    public BigDecimal getPriceVariation24Hours() {
        return this.priceVariation24Hours;
    }

    @Override
    public BigDecimal getPriceVariation7Days() {
        return this.priceVariation7Days;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JacksonTicker ticker = (JacksonTicker)o;
        if (this.lastPrice != null ? !this.lastPrice.equals(ticker.lastPrice) : ticker.lastPrice != null) {
            return false;
        }
        if (this.minAsk != null ? !this.minAsk.equals(ticker.minAsk) : ticker.minAsk != null) {
            return false;
        }
        if (this.maxBid != null ? !this.maxBid.equals(ticker.maxBid) : ticker.maxBid != null) {
            return false;
        }
        if (this.volume != null ? !this.volume.equals(ticker.volume) : ticker.volume != null) {
            return false;
        }
        if (this.priceVariation24Hours != null ? !this.priceVariation24Hours.equals(ticker.priceVariation24Hours) : ticker.priceVariation24Hours != null) {
            return false;
        }
        return this.priceVariation7Days != null ? this.priceVariation7Days.equals(ticker.priceVariation7Days) : ticker.priceVariation7Days == null;
    }

    public int hashCode() {
        int result = this.lastPrice != null ? this.lastPrice.hashCode() : 0;
        result = 31 * result + (this.minAsk != null ? this.minAsk.hashCode() : 0);
        result = 31 * result + (this.maxBid != null ? this.maxBid.hashCode() : 0);
        result = 31 * result + (this.volume != null ? this.volume.hashCode() : 0);
        result = 31 * result + (this.priceVariation24Hours != null ? this.priceVariation24Hours.hashCode() : 0);
        result = 31 * result + (this.priceVariation7Days != null ? this.priceVariation7Days.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Ticker{lastPrice=" + this.lastPrice + ", minAsk=" + this.minAsk + ", maxBid=" + this.maxBid + ", volume=" + this.volume + ", priceVariation24Hours=" + this.priceVariation24Hours + ", priceVariation7Days=" + this.priceVariation7Days + '}';
    }
}

