/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.jackson;

import cl.daplay.jsurbtc.Constants;
import cl.daplay.jsurbtc.JSON;
import cl.daplay.jsurbtc.jackson.dto.ApiKeyDTO;
import cl.daplay.jsurbtc.jackson.dto.BalanceDTO;
import cl.daplay.jsurbtc.jackson.dto.BalancesDTO;
import cl.daplay.jsurbtc.jackson.dto.DepositsDTO;
import cl.daplay.jsurbtc.jackson.dto.ExceptionDTO;
import cl.daplay.jsurbtc.jackson.dto.MarketsDTO;
import cl.daplay.jsurbtc.jackson.dto.OrderBookDTO;
import cl.daplay.jsurbtc.jackson.dto.OrderDTO;
import cl.daplay.jsurbtc.jackson.dto.OrdersDTO;
import cl.daplay.jsurbtc.jackson.dto.PageDTO;
import cl.daplay.jsurbtc.jackson.dto.TickerDTO;
import cl.daplay.jsurbtc.jackson.dto.TradesDTO;
import cl.daplay.jsurbtc.jackson.dto.WithdrawalsDTO;
import cl.daplay.jsurbtc.model.ApiKey;
import cl.daplay.jsurbtc.model.Balance;
import cl.daplay.jsurbtc.model.Deposit;
import cl.daplay.jsurbtc.model.JSurbtcException;
import cl.daplay.jsurbtc.model.Market;
import cl.daplay.jsurbtc.model.Order;
import cl.daplay.jsurbtc.model.OrderBook;
import cl.daplay.jsurbtc.model.Page;
import cl.daplay.jsurbtc.model.Ticker;
import cl.daplay.jsurbtc.model.Trades;
import cl.daplay.jsurbtc.model.Withdrawal;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public enum JacksonJSON implements JSON
{
    INSTANCE;

    private final ObjectMapper objectMapper = JacksonJSON.newObjectMapper();
    private final DecimalFormat decimalFormat = Constants.newBigDecimalFormat();

    public static ObjectMapper newObjectMapper() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return new ObjectMapper().setDateFormat((DateFormat)simpleDateFormat).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    }

    @Override
    public String newAPIKey(String name, Instant expiration) throws IOException {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("name", name);
        payload.put("expiration_time", expiration);
        return this.objectMapper.writeValueAsString(Collections.singletonMap("api_key", payload));
    }

    @Override
    public String newOrder(String marketId, String orderType, String orderPriceType, BigDecimal qty, BigDecimal price) throws IOException {
        LinkedHashMap<String, String> payload = new LinkedHashMap<String, String>();
        payload.put("type", orderType);
        payload.put("price_type", orderPriceType);
        payload.put("limit", this.decimalFormat.format(price));
        payload.put("amount", this.decimalFormat.format(qty));
        return this.objectMapper.writeValueAsString(Collections.singletonMap("order", payload));
    }

    @Override
    public String cancelOrder(long __) throws IOException {
        return this.objectMapper.writeValueAsString(Collections.singletonMap("state", "CANCELING"));
    }

    @Override
    public ApiKey apiKey(String json) throws IOException {
        return ((ApiKeyDTO)this.objectMapper.readValue(json, ApiKeyDTO.class)).getApiKey();
    }

    @Override
    public List<Market> markets(String json) throws IOException {
        return ((MarketsDTO)this.objectMapper.readValue(json, MarketsDTO.class)).getMarkets().stream().collect(Collectors.toList());
    }

    @Override
    public Order order(String json) throws IOException {
        return ((OrderDTO)this.objectMapper.readValue(json, OrderDTO.class)).getOrder();
    }

    @Override
    public Ticker ticker(String json) throws IOException {
        return ((TickerDTO)this.objectMapper.readValue(json, TickerDTO.class)).getTicker();
    }

    @Override
    public OrderBook orderBook(String json) throws IOException {
        return ((OrderBookDTO)this.objectMapper.readValue(json, OrderBookDTO.class)).getOrderBook();
    }

    @Override
    public Balance balance(String json) throws IOException {
        return ((BalanceDTO)this.objectMapper.readValue(json, BalanceDTO.class)).getBalance();
    }

    @Override
    public Trades trades(String json) throws IOException {
        return ((TradesDTO)this.objectMapper.readValue(json, TradesDTO.class)).getTrades();
    }

    @Override
    public List<Balance> balances(String json) throws IOException {
        return ((BalancesDTO)this.objectMapper.readValue(json, BalancesDTO.class)).getBalances().stream().collect(Collectors.toList());
    }

    @Override
    public List<Order> orders(String json) throws IOException {
        return ((OrdersDTO)this.objectMapper.readValue(json, OrdersDTO.class)).getOrders().stream().collect(Collectors.toList());
    }

    @Override
    public List<Deposit> deposits(String json) throws IOException {
        return ((DepositsDTO)this.objectMapper.readValue(json, DepositsDTO.class)).getDeposits().stream().collect(Collectors.toList());
    }

    @Override
    public List<Withdrawal> withdrawls(String json) throws IOException {
        return ((WithdrawalsDTO)this.objectMapper.readValue(json, WithdrawalsDTO.class)).getWithdrawals().stream().collect(Collectors.toList());
    }

    @Override
    public Page page(String json) throws IOException {
        return ((PageDTO)this.objectMapper.readValue(json, PageDTO.class)).getMeta();
    }

    @Override
    public JSurbtcException exception(int statusCode, String json) throws Exception {
        ExceptionDTO exceptionDTO = (ExceptionDTO)this.objectMapper.readValue(json, ExceptionDTO.class);
        if (null == exceptionDTO) {
            throw new Exception(String.format("Surbtc request failed. status code: '%d' response body: '%s'", statusCode, json));
        }
        return this.error2Error(statusCode, exceptionDTO);
    }

    private JSurbtcException.Detail error2Error(ExceptionDTO.ErrorDTO in) {
        return new JSurbtcException.Detail(in.resource, in.field, in.code, in.message);
    }

    private JSurbtcException error2Error(int statusCode, ExceptionDTO in) {
        ExceptionDTO.ErrorDTO[] dtos = in.errors == null ? new ExceptionDTO.ErrorDTO[]{} : in.errors;
        JSurbtcException.Detail[] details = (JSurbtcException.Detail[])Arrays.stream(dtos).map(this::error2Error).toArray(JSurbtcException.Detail[]::new);
        return new JSurbtcException(statusCode, in.message, in.code, details);
    }
}

