/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc;

import cl.daplay.jsurbtc.Constants;
import cl.daplay.jsurbtc.HTTPClient;
import cl.daplay.jsurbtc.JSON;
import cl.daplay.jsurbtc.Signer;
import cl.daplay.jsurbtc.Surbtc;
import cl.daplay.jsurbtc.VersionSupplier;
import cl.daplay.jsurbtc.fun.ThrowingFunction;
import cl.daplay.jsurbtc.http.DefaultHTTPClient;
import cl.daplay.jsurbtc.http.RetryHTTPClient;
import cl.daplay.jsurbtc.jackson.JacksonJSON;
import cl.daplay.jsurbtc.lazylist.LazyList;
import cl.daplay.jsurbtc.model.ApiKey;
import cl.daplay.jsurbtc.model.Balance;
import cl.daplay.jsurbtc.model.Deposit;
import cl.daplay.jsurbtc.model.Market;
import cl.daplay.jsurbtc.model.Order;
import cl.daplay.jsurbtc.model.OrderBook;
import cl.daplay.jsurbtc.model.Page;
import cl.daplay.jsurbtc.model.Ticker;
import cl.daplay.jsurbtc.model.Trades;
import cl.daplay.jsurbtc.model.Withdrawal;
import cl.daplay.jsurbtc.signer.DefaultSigner;
import cl.daplay.jsurbtc.signer.DoNothingSigner;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongSupplier;
import java.util.logging.Logger;

public class JSurbtc
implements Surbtc {
    private static final Logger LOGGER = Logger.getLogger(JSurbtc.class.getName());
    private static final VersionSupplier VERSION_SUPPLIER = VersionSupplier.INSTANCE;
    private static final int HTTP_MAX_RETRY = Integer.parseInt(System.getProperty("JSURBTC.HTTP_MAX_RETRY", "5"), 10);
    private final DecimalFormat bigDecimalFormat;
    private final HTTPClient httpClient;
    private final JSON json;
    private final Signer defaultSigner;
    private final Signer noSignatureSigner;

    public static LongSupplier newNonce() {
        return new AtomicLong(System.currentTimeMillis())::getAndIncrement;
    }

    public JSurbtc() {
        this(null, null, JSurbtc.newNonce(), null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret) {
        this(key, secret, JSurbtc.newNonce(), null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier) {
        this(key, secret, nonceSupplier, null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier, InetSocketAddress httpProxy, int httpMaxRetry) {
        this(key, secret, nonceSupplier, JacksonJSON.INSTANCE, httpProxy == null ? null : new Proxy(Proxy.Type.HTTP, httpProxy), httpMaxRetry);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier, JacksonJSON json, Proxy proxy, int httpMaxRetry) {
        this(new RetryHTTPClient(new DefaultHTTPClient(proxy, key, nonceSupplier, VERSION_SUPPLIER.get()), httpMaxRetry), Constants.newBigDecimalFormat(), (JSON)json, new DefaultSigner(secret), DoNothingSigner.INSTANCE);
    }

    public JSurbtc(JSurbtc other) {
        this.bigDecimalFormat = other.bigDecimalFormat;
        this.httpClient = other.httpClient;
        this.json = other.json;
        this.defaultSigner = other.defaultSigner;
        this.noSignatureSigner = other.noSignatureSigner;
    }

    public JSurbtc(HTTPClient httpClient, DecimalFormat bigDecimalFormat, JSON json, Signer defaultSigner, Signer noSignatureSigner) {
        this.bigDecimalFormat = bigDecimalFormat;
        this.httpClient = httpClient;
        this.json = json;
        this.defaultSigner = defaultSigner;
        this.noSignatureSigner = noSignatureSigner;
    }

    public ApiKey newAPIKey(String name, Instant expiration) throws Exception {
        String path = "/api/v2/api_keys";
        return (ApiKey)this.httpClient.post("/api/v2/api_keys", this.defaultSigner, this.json.newAPIKey(name, expiration), this.responseHandler(arg_0 -> ((JSON)this.json).apiKey(arg_0)));
    }

    public Order newOrder(String marketId, String orderType, String orderPriceType, BigDecimal qty, BigDecimal price) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders", marketId).toLowerCase();
        String payload = this.json.newOrder(marketId, orderType, orderPriceType, qty, price);
        return (Order)this.httpClient.post(path, this.defaultSigner, payload, this.responseHandler(arg_0 -> ((JSON)this.json).order(arg_0)));
    }

    public Trades getTrades(String marketId) throws Exception {
        return this.getTrades(marketId, null);
    }

    public Trades getTrades(String marketId, Instant timestamp) throws Exception {
        String path = String.format("/api/v2/markets/%s/trades", marketId).toLowerCase();
        if (timestamp != null) {
            path = path + "?timestamp=" + timestamp.toEpochMilli();
        }
        return (Trades)this.httpClient.get(path, this.noSignatureSigner, this.responseHandler(arg_0 -> ((JSON)this.json).trades(arg_0)));
    }

    public Order cancelOrder(long orderId) throws Exception {
        this.checkOrderId(orderId);
        String path = String.format("/api/v2/orders/%d", orderId);
        String payload = this.json.cancelOrder(orderId);
        return (Order)this.httpClient.put(path, this.defaultSigner, payload, this.responseHandler(arg_0 -> ((JSON)this.json).order(arg_0)));
    }

    public List<Market> getMarkets() throws Exception {
        String path = "/api/v2/markets";
        return (List)this.httpClient.get("/api/v2/markets", this.noSignatureSigner, this.responseHandler(arg_0 -> ((JSON)this.json).markets(arg_0)));
    }

    public Ticker getTicker(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/ticker", marketId).toLowerCase();
        return (Ticker)this.httpClient.get(path, this.noSignatureSigner, this.responseHandler(arg_0 -> ((JSON)this.json).ticker(arg_0)));
    }

    public OrderBook getOrderBook(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/order_book", marketId).toLowerCase();
        return (OrderBook)this.httpClient.get(path, this.noSignatureSigner, this.responseHandler(arg_0 -> ((JSON)this.json).orderBook(arg_0)));
    }

    public Balance getBalance(String currency) throws Exception {
        String path = String.format("/api/v2/balances/%s", currency).toLowerCase();
        return (Balance)this.httpClient.get(path, this.defaultSigner, this.responseHandler(arg_0 -> ((JSON)this.json).balance(arg_0)));
    }

    public List<Balance> getBalances() throws Exception {
        return (List)this.httpClient.get("/api/v2/balances", this.defaultSigner, this.responseHandler(arg_0 -> ((JSON)this.json).balances(arg_0)));
    }

    public List<Order> getOrders(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders", marketId).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).orders(arg_0));
    }

    public List<Order> getOrders(String marketId, String orderState) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?state=%s&algo=", marketId, orderState).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).orders(arg_0));
    }

    public List<Order> getOrders(String marketId, BigDecimal minimunExchanged) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?minimun_exchanged=%s", marketId, this.bigDecimalFormat.format(minimunExchanged)).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).orders(arg_0));
    }

    public List<Order> getOrders(String marketId, String orderState, BigDecimal minimunExchanged) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?state=%s&minimun_exchanged=%s", marketId, orderState, this.bigDecimalFormat.format(minimunExchanged)).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).orders(arg_0));
    }

    public Order getOrder(long orderId) throws Exception {
        this.checkOrderId(orderId);
        String path = String.format("/api/v2/orders/%d", orderId).toLowerCase();
        return (Order)this.httpClient.get(path, this.defaultSigner, this.responseHandler(arg_0 -> ((JSON)this.json).order(arg_0)));
    }

    public List<Deposit> getDeposits(String currency) throws Exception {
        String path = String.format("/api/v2/currencies/%s/deposits", currency).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).deposits(arg_0));
    }

    public List<Withdrawal> getWithdrawals(String currency) throws Exception {
        String path = String.format("/api/v2/currencies/%s/withdrawals", currency).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, arg_0 -> ((JSON)this.json).withdrawls(arg_0));
    }

    public String getVersion() {
        return VERSION_SUPPLIER.get();
    }

    private <T> LazyList<T> newPaginatedList(String path, Signer signer, ThrowingFunction<String, List<T>> parseList) throws Exception {
        return (LazyList)this.httpClient.get(path, signer, this.responseHandler(responseBody -> {
            List page = (List)parseList.apply(responseBody);
            Page pagination = this.json.page(responseBody);
            int totalPages = pagination.getTotalPages();
            int totalCount = pagination.getTotalCount();
            return new LazyList(page, index -> {
                boolean append = path.contains("?");
                String nextPath = String.format("%s%spage=%d", path, append ? "&" : "?", index + 1);
                return (List)this.httpClient.get(nextPath, signer, this.responseHandler(parseList));
            }, totalPages, totalCount);
        }));
    }

    private void checkOrderId(long orderId) {
        if (orderId <= 0L) {
            throw new IllegalArgumentException(String.format("invalid order id: %d", orderId));
        }
    }

    private <T> HTTPClient.HTTPResponseHandler<T> responseHandler(ThrowingFunction<String, T> mapper) {
        return (statusCode, responseBody) -> {
            boolean successful;
            boolean bl = successful = statusCode == 200 || statusCode == 201;
            if (!successful) {
                throw this.json.exception(statusCode, responseBody);
            }
            return mapper.apply((Object)responseBody);
        };
    }
}

