/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.signers;

import cl.daplay.jsurbtc.JSurbtcException;
import cl.daplay.jsurbtc.Signer;
import java.math.BigInteger;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class DefaultSigner
implements Signer {
    private static final String HMAC_SHA384_ALGORITHM = "HmacSHA384";
    private final String secret;

    public DefaultSigner(String secret) {
        this.secret = secret;
    }

    @Override
    public String sign(String body, String method, String path, long nonce) throws Exception {
        String message = this.buildMessage(body, method, path, nonce);
        return this.sign(message);
    }

    private String sign(String message) throws Exception {
        if (this.secret == null || this.secret.isEmpty()) {
            throw new JSurbtcException("API Secret is missing, can't use private APIs");
        }
        SecretKeySpec signingKey = new SecretKeySpec(this.secret.getBytes(), HMAC_SHA384_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA384_ALGORITHM);
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(message.getBytes());
        return String.format("%040x", new BigInteger(1, rawHmac));
    }

    private String buildMessage(String body, String method, String path, long nonce) {
        boolean containsBody;
        boolean bl = containsBody = !body.isEmpty();
        if (containsBody) {
            String base64EncodedBody = Base64.getEncoder().encodeToString(body.getBytes());
            return String.format("%s %s %s %d", method, path, base64EncodedBody, nonce);
        }
        return String.format("%s %s %d", method, path, nonce);
    }
}

