/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.model.balance;

import cl.daplay.jsurbtc.model.Amount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;

@JsonPropertyOrder(value={"id", "amount", "available_amount", "frozen_amount", "pending_withdraw_amount", "account_id"})
public class Balance
implements Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="account_id")
    private final long accountId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="amount")
    private final Amount amount;
    @JsonProperty(value="available_amount")
    private final Amount availableAmount;
    @JsonProperty(value="frozen_amount")
    private final Amount frozenAmount;
    @JsonProperty(value="pending_withdraw_amount")
    private final Amount pendingWithdrawAmount;

    public Balance(Balance other) {
        this.accountId = other.accountId;
        this.id = other.id;
        this.amount = other.amount;
        this.availableAmount = other.availableAmount;
        this.frozenAmount = other.frozenAmount;
        this.pendingWithdrawAmount = other.pendingWithdrawAmount;
    }

    @JsonCreator
    public Balance(@JsonProperty(value="account_id") long accountId, @JsonProperty(value="id") String id, @JsonProperty(value="amount") Amount amount, @JsonProperty(value="available_amount") Amount availableAmount, @JsonProperty(value="frozen_amount") Amount frozenAmount, @JsonProperty(value="pending_withdraw_amount") Amount pendingWithdrawAmount) {
        this.accountId = accountId;
        this.id = id;
        this.amount = amount;
        this.availableAmount = availableAmount;
        this.frozenAmount = frozenAmount;
        this.pendingWithdrawAmount = pendingWithdrawAmount;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public String getId() {
        return this.id;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Amount getAvailableAmount() {
        return this.availableAmount;
    }

    public Amount getFrozenAmount() {
        return this.frozenAmount;
    }

    public Amount getPendingWithdrawAmount() {
        return this.pendingWithdrawAmount;
    }

    public String toString() {
        return "Balance{accountId=" + this.accountId + ", id='" + this.id + '\'' + ", amount=" + this.amount + ", availableAmount=" + this.availableAmount + ", frozenAmount=" + this.frozenAmount + ", pendingWithdrawAmount=" + this.pendingWithdrawAmount + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        if (this.accountId != balance.accountId) {
            return false;
        }
        if (this.id != null ? !this.id.equals(balance.id) : balance.id != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(balance.amount) : balance.amount != null) {
            return false;
        }
        if (this.availableAmount != null ? !this.availableAmount.equals(balance.availableAmount) : balance.availableAmount != null) {
            return false;
        }
        if (this.frozenAmount != null ? !this.frozenAmount.equals(balance.frozenAmount) : balance.frozenAmount != null) {
            return false;
        }
        return this.pendingWithdrawAmount != null ? this.pendingWithdrawAmount.equals(balance.pendingWithdrawAmount) : balance.pendingWithdrawAmount == null;
    }

    public int hashCode() {
        int result = (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.availableAmount != null ? this.availableAmount.hashCode() : 0);
        result = 31 * result + (this.frozenAmount != null ? this.frozenAmount.hashCode() : 0);
        result = 31 * result + (this.pendingWithdrawAmount != null ? this.pendingWithdrawAmount.hashCode() : 0);
        return result;
    }
}

