/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.model;

import cl.daplay.jsurbtc.jackson.BigDecimalToStringSerializer;
import cl.daplay.jsurbtc.model.Amount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;

public class Ticker
implements Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="last_price")
    private final Amount lastPrice;
    @JsonProperty(value="min_ask")
    private final Amount minAsk;
    @JsonProperty(value="max_bid")
    private final Amount maxBid;
    @JsonProperty(value="volume")
    private final Amount volume;
    @JsonProperty(value="price_variation_24h")
    @JsonSerialize(using=BigDecimalToStringSerializer.class)
    private final BigDecimal priceVariation24Hours;
    @JsonProperty(value="price_variation_7d")
    @JsonSerialize(using=BigDecimalToStringSerializer.class)
    private final BigDecimal priceVariation7Days;

    public Ticker(Ticker other) {
        this.lastPrice = other.lastPrice;
        this.minAsk = other.minAsk;
        this.maxBid = other.maxBid;
        this.volume = other.volume;
        this.priceVariation24Hours = other.priceVariation24Hours;
        this.priceVariation7Days = other.priceVariation7Days;
    }

    @JsonCreator
    public Ticker(@JsonProperty(value="last_price") Amount lastPrice, @JsonProperty(value="min_ask") Amount minAsk, @JsonProperty(value="max_bid") Amount maxBid, @JsonProperty(value="volume") Amount volume, @JsonProperty(value="price_variation_24h") BigDecimal priceVariation24Hours, @JsonProperty(value="price_variation_7d") BigDecimal priceVariation7Days) {
        this.lastPrice = lastPrice;
        this.minAsk = minAsk;
        this.maxBid = maxBid;
        this.volume = volume;
        this.priceVariation24Hours = priceVariation24Hours;
        this.priceVariation7Days = priceVariation7Days;
    }

    public Amount getLastPrice() {
        return this.lastPrice;
    }

    public Amount getMinAsk() {
        return this.minAsk;
    }

    public Amount getMaxBid() {
        return this.maxBid;
    }

    public Amount getVolume() {
        return this.volume;
    }

    public BigDecimal getPriceVariation24Hours() {
        return this.priceVariation24Hours;
    }

    public BigDecimal getPriceVariation7Days() {
        return this.priceVariation7Days;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ticker ticker = (Ticker)o;
        if (this.lastPrice != null ? !this.lastPrice.equals(ticker.lastPrice) : ticker.lastPrice != null) {
            return false;
        }
        if (this.minAsk != null ? !this.minAsk.equals(ticker.minAsk) : ticker.minAsk != null) {
            return false;
        }
        if (this.maxBid != null ? !this.maxBid.equals(ticker.maxBid) : ticker.maxBid != null) {
            return false;
        }
        if (this.volume != null ? !this.volume.equals(ticker.volume) : ticker.volume != null) {
            return false;
        }
        if (this.priceVariation24Hours != null ? !this.priceVariation24Hours.equals(ticker.priceVariation24Hours) : ticker.priceVariation24Hours != null) {
            return false;
        }
        return this.priceVariation7Days != null ? this.priceVariation7Days.equals(ticker.priceVariation7Days) : ticker.priceVariation7Days == null;
    }

    public int hashCode() {
        int result = this.lastPrice != null ? this.lastPrice.hashCode() : 0;
        result = 31 * result + (this.minAsk != null ? this.minAsk.hashCode() : 0);
        result = 31 * result + (this.maxBid != null ? this.maxBid.hashCode() : 0);
        result = 31 * result + (this.volume != null ? this.volume.hashCode() : 0);
        result = 31 * result + (this.priceVariation24Hours != null ? this.priceVariation24Hours.hashCode() : 0);
        result = 31 * result + (this.priceVariation7Days != null ? this.priceVariation7Days.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Ticker{lastPrice=" + this.lastPrice + ", minAsk=" + this.minAsk + ", maxBid=" + this.maxBid + ", volume=" + this.volume + ", priceVariation24Hours=" + this.priceVariation24Hours + ", priceVariation7Days=" + this.priceVariation7Days + '}';
    }
}

