/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.time.Instant;

@JsonPropertyOrder(value={"id", "name", "expiration_time", "enabled", "expired", "last_access_at", "secret"})
public class ApiKey
implements Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="expiration_time")
    private final Instant expirationTime;
    @JsonProperty(value="enabled")
    private final boolean enabled;
    @JsonProperty(value="expired")
    private final boolean expired;
    @JsonProperty(value="last_access_at")
    private final Instant lastAccessAt;
    @JsonProperty(value="secret")
    private final String secret;

    public ApiKey(ApiKey other) {
        this.id = other.id;
        this.name = other.name;
        this.expirationTime = other.expirationTime;
        this.enabled = other.enabled;
        this.expired = other.expired;
        this.lastAccessAt = other.lastAccessAt;
        this.secret = other.secret;
    }

    @JsonCreator
    public ApiKey(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="expiration_date") Instant expirationTime, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="expired") boolean expired, @JsonProperty(value="last_access_at") Instant lastAccessAt, @JsonProperty(value="secret") String secret) {
        this.id = id;
        this.name = name;
        this.expirationTime = expirationTime;
        this.enabled = enabled;
        this.expired = expired;
        this.lastAccessAt = lastAccessAt;
        this.secret = secret;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public Instant getLastAccessAt() {
        return this.lastAccessAt;
    }

    public String getSecret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKey apiKey = (ApiKey)o;
        if (this.enabled != apiKey.enabled) {
            return false;
        }
        if (this.expired != apiKey.expired) {
            return false;
        }
        if (this.id != null ? !this.id.equals(apiKey.id) : apiKey.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(apiKey.name) : apiKey.name != null) {
            return false;
        }
        if (this.expirationTime != null ? !this.expirationTime.equals(apiKey.expirationTime) : apiKey.expirationTime != null) {
            return false;
        }
        if (this.lastAccessAt != null ? !this.lastAccessAt.equals(apiKey.lastAccessAt) : apiKey.lastAccessAt != null) {
            return false;
        }
        return this.secret != null ? this.secret.equals(apiKey.secret) : apiKey.secret == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.expirationTime != null ? this.expirationTime.hashCode() : 0);
        result = 31 * result + (this.enabled ? 1 : 0);
        result = 31 * result + (this.expired ? 1 : 0);
        result = 31 * result + (this.lastAccessAt != null ? this.lastAccessAt.hashCode() : 0);
        result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "APIKey{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", expirationTime=" + this.expirationTime + ", enabled=" + this.enabled + ", expired=" + this.expired + ", lastAccessAt=" + this.lastAccessAt + ", secret='" + this.secret + '\'' + '}';
    }
}

