/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.model;

import cl.daplay.jsurbtc.jackson.BigDecimalToStringSerializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
@JsonPropertyOrder(value={"amount", "currency"})
public class Amount
extends BigDecimal
implements Serializable {
    private static final long serialVersionUID = 20170806L;
    @JsonProperty(value="currency")
    private final String currency;
    @JsonProperty(value="amount")
    @JsonSerialize(using=BigDecimalToStringSerializer.class)
    private final BigDecimal amount;

    private static BigDecimal unwrap(BigDecimal o) {
        if (o instanceof Amount) {
            return ((Amount)o).getAmount();
        }
        return o;
    }

    public Amount(Amount other) {
        this(other.getCurrency(), other.getAmount());
    }

    @JsonCreator
    public Amount(@JsonProperty(value="currency") String currency, @JsonProperty(value="amount") BigDecimal amount) {
        super(Amount.unwrap(amount).toString());
        Objects.requireNonNull(currency);
        Objects.requireNonNull(amount);
        this.currency = currency;
        this.amount = Amount.unwrap(amount);
    }

    public String getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public Amount abs() {
        return new Amount(this.currency, super.abs());
    }

    @Override
    public Amount abs(MathContext mc) {
        return new Amount(this.currency, super.abs(mc));
    }

    @Override
    public Amount negate() {
        return new Amount(this.currency, super.negate());
    }

    @Override
    public Amount negate(MathContext mc) {
        return new Amount(this.currency, super.negate(mc));
    }

    public Amount add(Amount o) {
        return new Amount(this.currency, super.add(o));
    }

    public Amount add(Amount o, MathContext mc) {
        return new Amount(this.currency, super.add(o, mc));
    }

    public Amount subtract(Amount subtrahend) {
        return new Amount(this.currency, super.subtract(subtrahend));
    }

    public Amount subtract(Amount subtrahend, MathContext mc) {
        return new Amount(this.currency, super.subtract(subtrahend, mc));
    }

    public Amount multiply(Amount multiplicand) {
        return new Amount(this.currency, super.multiply(multiplicand));
    }

    public Amount multiply(Amount multiplicand, MathContext mc) {
        return new Amount(this.currency, super.multiply(multiplicand, mc));
    }

    public Amount divide(Amount divisor, int scale, int roundingMode) {
        return new Amount(this.currency, super.divide((BigDecimal)divisor, scale, roundingMode));
    }

    public Amount divide(Amount divisor, int scale, RoundingMode roundingMode) {
        return new Amount(this.currency, super.divide((BigDecimal)divisor, scale, roundingMode));
    }

    public Amount divide(Amount divisor, int roundingMode) {
        return new Amount(this.currency, super.divide((BigDecimal)divisor, roundingMode));
    }

    public Amount divide(Amount divisor, RoundingMode roundingMode) {
        return new Amount(this.currency, super.divide(divisor.getAmount(), roundingMode));
    }

    public Amount divide(Amount divisor) {
        return new Amount(this.currency, super.divide(divisor.getAmount(), RoundingMode.HALF_UP));
    }

    public Amount divide(Amount divisor, MathContext mc) {
        return new Amount(this.currency, super.divide((BigDecimal)divisor, mc));
    }

    public Amount remainder(Amount divisor) {
        return new Amount(this.currency, super.remainder(divisor));
    }

    public Amount remainder(Amount divisor, MathContext mc) {
        return new Amount(this.currency, super.remainder(divisor, mc));
    }

    @Override
    public Amount add(BigDecimal augend) {
        return new Amount(this.currency, super.add(augend));
    }

    @Override
    public Amount add(BigDecimal augend, MathContext mc) {
        return new Amount(this.currency, super.add(augend, mc));
    }

    @Override
    public Amount subtract(BigDecimal subtrahend) {
        return new Amount(this.currency, super.subtract(subtrahend));
    }

    @Override
    public Amount subtract(BigDecimal subtrahend, MathContext mc) {
        return new Amount(this.currency, super.subtract(subtrahend, mc));
    }

    @Override
    public Amount multiply(BigDecimal multiplicand) {
        return new Amount(this.currency, super.multiply(multiplicand));
    }

    @Override
    public Amount multiply(BigDecimal multiplicand, MathContext mc) {
        return new Amount(this.currency, super.multiply(multiplicand, mc));
    }

    @Override
    public Amount divide(BigDecimal divisor, int scale, int roundingMode) {
        return new Amount(this.currency, super.divide(divisor, scale, roundingMode));
    }

    @Override
    public Amount divide(BigDecimal divisor, int scale, RoundingMode roundingMode) {
        return new Amount(this.currency, super.divide(divisor, scale, roundingMode));
    }

    @Override
    public Amount divide(BigDecimal divisor, int roundingMode) {
        return new Amount(this.currency, super.divide(divisor, roundingMode));
    }

    @Override
    public Amount divide(BigDecimal divisor, RoundingMode roundingMode) {
        return new Amount(this.currency, super.divide(divisor, roundingMode));
    }

    @Override
    public Amount divide(BigDecimal divisor) {
        return new Amount(this.currency, super.divide(divisor));
    }

    @Override
    public Amount divide(BigDecimal divisor, MathContext mc) {
        return new Amount(this.currency, super.divide(divisor, mc));
    }

    @Override
    public Amount remainder(BigDecimal divisor) {
        return new Amount(this.currency, super.remainder(divisor));
    }

    @Override
    public Amount remainder(BigDecimal divisor, MathContext mc) {
        return new Amount(this.currency, super.remainder(divisor, mc));
    }

    @Override
    public Amount pow(int n) {
        return new Amount(this.currency, super.pow(n));
    }

    @Override
    public Amount pow(int n, MathContext mc) {
        return new Amount(this.currency, super.pow(n, mc));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Amount amount = (Amount)o;
        return this.currency.equals(amount.currency);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.currency.hashCode();
        return result;
    }

    @Override
    public final String toString() {
        return String.format("%s %s", this.currency, super.toString());
    }
}

