/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.lazylist;

import cl.daplay.jsurbtc.lazylist.LazyListException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;

public final class LazyList<T>
extends AbstractList<T>
implements Serializable {
    private static final long serialVersionUID = 20170806L;
    private static LazyList<?> EMPTY = new LazyList(Collections.emptyList(), __ -> Collections.emptyList(), 0, 0);
    private final int pageSize;
    private final int totalCount;
    private final int totalPages;
    private final Object[] pages;
    private final GetPage<T> nextPage;

    public static <K> LazyList<K> empty() {
        return EMPTY;
    }

    static int indexInPage(int index, int pageSize) {
        int page = LazyList.pageForIndex(index, pageSize);
        int offset = pageSize * page;
        return index - offset;
    }

    static int pageForIndex(int index, int pageSize) {
        return index / pageSize;
    }

    static boolean isValidIndex(int index, int totalCount) {
        return index >= 0 && index < totalCount;
    }

    public LazyList(List<T> firstPage, GetPage<T> nextPage, int totalPages, int totalCount) {
        this.pages = new Object[Math.max(1, totalPages)];
        this.pages[0] = firstPage;
        this.totalCount = totalCount;
        this.totalPages = totalPages;
        this.pageSize = firstPage.size();
        this.nextPage = nextPage;
    }

    @Override
    public T get(int index) {
        List<T> page;
        if (!LazyList.isValidIndex(index, this.totalCount)) {
            throw new IllegalArgumentException(String.format("get(index=%d), illegal index", index));
        }
        int pageForIndex = LazyList.pageForIndex(index, this.pageSize);
        try {
            page = this.getPage(pageForIndex);
        }
        catch (Exception e) {
            throw new LazyListException(e);
        }
        int indexInPage = LazyList.indexInPage(index, this.pageSize);
        return page.get(indexInPage);
    }

    @Override
    public int size() {
        return this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getPage(int pageForIndex) throws Exception {
        if (!LazyList.isValidIndex(pageForIndex, this.totalPages)) {
            throw new IllegalArgumentException(String.format("nextPage(pageForIndex=%d), illegal pageForIndex", pageForIndex));
        }
        Object[] objectArray = this.pages;
        synchronized (this.pages) {
            if (this.pages[pageForIndex] == null) {
                this.pages[pageForIndex] = this.nextPage.getPage(pageForIndex);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (List)this.pages[pageForIndex];
        }
    }

    @FunctionalInterface
    public static interface GetPage<T> {
        public List<T> getPage(int var1) throws Exception;
    }
}

