/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc.http;

import cl.daplay.jsurbtc.HTTPClient;
import cl.daplay.jsurbtc.JSurbtcException;
import cl.daplay.jsurbtc.Signer;
import cl.daplay.jsurbtc.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Optional;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.zip.GZIPInputStream;

public final class DefaultHTTPClient
implements HTTPClient {
    private static final String BASE_PATH = "https://www.surbtc.com";
    private final Proxy proxy;
    private final String key;
    private final LongSupplier nonceSupplier;
    private final String version;

    public DefaultHTTPClient(Proxy proxy, String key, LongSupplier nonceSupplier, String version) {
        this.proxy = proxy;
        this.key = key;
        this.nonceSupplier = nonceSupplier;
        this.version = version;
    }

    @Override
    public <T> T get(String path, Signer signer, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return this.doRequest(path, signer, "GET", null, responseHandler);
    }

    @Override
    public <T> T put(String path, Signer signer, Supplier<String> jsonBody, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return this.doRequest(path, signer, "PUT", jsonBody, responseHandler);
    }

    @Override
    public <T> T post(String path, Signer signer, Supplier<String> jsonBody, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return this.doRequest(path, signer, "POST", jsonBody, responseHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doRequest(String path, Signer signer, String method, Supplier<String> bodySupplier, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        long nonce;
        URL url = new URL(BASE_PATH + path);
        HttpURLConnection con = (HttpURLConnection)(this.proxy == null ? url.openConnection() : url.openConnection(this.proxy));
        String requestBody = Optional.ofNullable(bodySupplier).map(Supplier::get).orElse("");
        String signature = signer.sign(requestBody, method, path, nonce = this.nonceSupplier.getAsLong());
        if (!signature.isEmpty()) {
            con.setRequestMethod(method);
            if (this.key == null || this.key.isEmpty()) {
                throw new JSurbtcException("API Key is missing.");
            }
            con.setRequestProperty("X-SBTC-APIKEY", this.key);
            con.setRequestProperty("X-SBTC-NONCE", Long.toString(nonce, 10));
            con.setRequestProperty("X-SBTC-SIGNATURE", signature);
            if (!requestBody.isEmpty()) {
                con.setRequestProperty("Content-Type", "application/json");
            }
        }
        con.setRequestProperty("accept", "application/json");
        con.setRequestProperty("Accept-Encoding", "gzip,deflate");
        con.setRequestProperty("User-Agent", "JSurbtc/" + this.version);
        try (Reader reader = null;){
            InputStream pipe;
            if (!requestBody.isEmpty()) {
                con.setDoOutput(true);
                OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream());
                writer.write(requestBody);
                writer.close();
            }
            reader = null != (pipe = this.pipe(con)) ? ("gzip".equals(con.getContentEncoding()) ? new InputStreamReader(new GZIPInputStream(this.pipe(con))) : new InputStreamReader(this.pipe(con))) : new StringReader("");
            int statusCode = con.getResponseCode();
            String body = Utils.convertStreamToString(reader);
            T t = responseHandler.handle(statusCode, body);
            return t;
        }
    }

    private InputStream pipe(HttpURLConnection con) {
        try {
            return con.getInputStream();
        }
        catch (IOException e) {
            return con.getErrorStream();
        }
    }
}

