/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc;

import cl.daplay.jsurbtc.Constants;
import cl.daplay.jsurbtc.HTTPClient;
import cl.daplay.jsurbtc.JSON;
import cl.daplay.jsurbtc.JSurbtcException;
import cl.daplay.jsurbtc.Signer;
import cl.daplay.jsurbtc.VersionSupplier;
import cl.daplay.jsurbtc.http.DefaultHTTPClient;
import cl.daplay.jsurbtc.http.RetryHTTPClient;
import cl.daplay.jsurbtc.jackson.dto.ApiKeyDTO;
import cl.daplay.jsurbtc.jackson.dto.BalanceDTO;
import cl.daplay.jsurbtc.jackson.dto.BalancesDTO;
import cl.daplay.jsurbtc.jackson.dto.DepositsDTO;
import cl.daplay.jsurbtc.jackson.dto.ExceptionDTO;
import cl.daplay.jsurbtc.jackson.dto.MarketsDTO;
import cl.daplay.jsurbtc.jackson.dto.OrderBookDTO;
import cl.daplay.jsurbtc.jackson.dto.OrderDTO;
import cl.daplay.jsurbtc.jackson.dto.OrdersDTO;
import cl.daplay.jsurbtc.jackson.dto.PaginationDTO;
import cl.daplay.jsurbtc.jackson.dto.TickerDTO;
import cl.daplay.jsurbtc.jackson.dto.TradesDTO;
import cl.daplay.jsurbtc.jackson.dto.WithdrawalsDTO;
import cl.daplay.jsurbtc.jackson.dto.request.APIKeyRequestDTO;
import cl.daplay.jsurbtc.jackson.dto.request.OrderRequestDTO;
import cl.daplay.jsurbtc.lazylist.LazyList;
import cl.daplay.jsurbtc.model.ApiKey;
import cl.daplay.jsurbtc.model.Ticker;
import cl.daplay.jsurbtc.model.balance.Balance;
import cl.daplay.jsurbtc.model.deposit.Deposit;
import cl.daplay.jsurbtc.model.market.Market;
import cl.daplay.jsurbtc.model.order.Order;
import cl.daplay.jsurbtc.model.order.OrderBook;
import cl.daplay.jsurbtc.model.trades.Trades;
import cl.daplay.jsurbtc.model.withdrawal.Withdrawal;
import cl.daplay.jsurbtc.signers.DefaultSigner;
import cl.daplay.jsurbtc.signers.DoNothingSigner;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.logging.Logger;

public class JSurbtc {
    private static final Logger LOGGER = Logger.getLogger(JSurbtc.class.getName());
    private static final VersionSupplier VERSION_SUPPLIER = VersionSupplier.INSTANCE;
    private static final int HTTP_MAX_RETRY = Integer.parseInt(System.getProperty("JSURBTC.HTTP_MAX_RETRY", "5"));
    private final DecimalFormat bigDecimalFormat;
    private final HTTPClient httpClient;
    private final JSON json;
    private final Signer defaultSigner;
    private final Signer noSignatureSigner;

    public static LongSupplier newNonce() {
        return new AtomicLong(System.currentTimeMillis())::getAndIncrement;
    }

    public JSurbtc() {
        this(null, null, JSurbtc.newNonce(), null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret) {
        this(key, secret, JSurbtc.newNonce(), null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier) {
        this(key, secret, nonceSupplier, null, HTTP_MAX_RETRY);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier, InetSocketAddress httpProxy, int httpMaxRetry) {
        this(key, secret, nonceSupplier, JSON.INSTANCE, httpProxy == null ? null : new Proxy(Proxy.Type.HTTP, httpProxy), httpMaxRetry);
    }

    public JSurbtc(String key, String secret, LongSupplier nonceSupplier, JSON json, Proxy proxy, int httpMaxRetry) {
        this(new RetryHTTPClient(new DefaultHTTPClient(proxy, key, nonceSupplier, VERSION_SUPPLIER.get()), httpMaxRetry), Constants.newBigDecimalFormat(), json, new DefaultSigner(secret), DoNothingSigner.INSTANCE);
    }

    public JSurbtc(JSurbtc other) {
        this.bigDecimalFormat = other.bigDecimalFormat;
        this.httpClient = other.httpClient;
        this.json = other.json;
        this.defaultSigner = other.defaultSigner;
        this.noSignatureSigner = other.noSignatureSigner;
    }

    public JSurbtc(HTTPClient httpClient, DecimalFormat bigDecimalFormat, JSON json, Signer defaultSigner, Signer noSignatureSigner) {
        this.bigDecimalFormat = bigDecimalFormat;
        this.httpClient = httpClient;
        this.json = json;
        this.defaultSigner = defaultSigner;
        this.noSignatureSigner = noSignatureSigner;
    }

    public ApiKey newAPIKey(String name, Instant expiration) throws Exception {
        String path = "/api/v2/api_keys";
        return this.post("/api/v2/api_keys", this.defaultSigner, new APIKeyRequestDTO(name, expiration), this.parser(ApiKeyDTO.class, ApiKeyDTO::getApiKey));
    }

    public Order newOrder(String marketId, String orderType, String orderPriceType, BigDecimal qty, BigDecimal price) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders", marketId).toLowerCase();
        OrderRequestDTO payload = new OrderRequestDTO(this.bigDecimalFormat, orderType, orderPriceType, qty, price);
        return this.post(path, this.defaultSigner, payload, this.parser(OrderDTO.class, OrderDTO::getOrder));
    }

    public Trades getTrades(String marketId, Instant timestamp) throws Exception {
        String path = String.format("/api/v2/markets/%s/trades", marketId).toLowerCase();
        if (timestamp != null) {
            path = path + "?timestamp=" + timestamp.toEpochMilli();
        }
        return this.get(path, this.noSignatureSigner, this.parser(TradesDTO.class, TradesDTO::getTrades));
    }

    public String getVersion() {
        return VERSION_SUPPLIER.get();
    }

    public Trades getTrades(String marketId) throws Exception {
        return this.getTrades(marketId, null);
    }

    public Order cancelOrder(long orderId) throws Exception {
        this.checkOrderId(orderId);
        String path = String.format("/api/v2/orders/%d", orderId);
        return this.httpClient.put(path, this.defaultSigner, this.json.payload(Collections.singletonMap("state", "CANCELING")), this.handlingErrors(this.parser(OrderDTO.class, OrderDTO::getOrder)));
    }

    public List<Market> getMarkets() throws Exception {
        String path = "/api/v2/markets";
        return this.get("/api/v2/markets", this.noSignatureSigner, MarketsDTO.class, MarketsDTO::getMarkets);
    }

    public Ticker getTicker(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/ticker", marketId).toLowerCase();
        return this.get(path, this.noSignatureSigner, TickerDTO.class, TickerDTO::getTicker);
    }

    public OrderBook getOrderBook(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/order_book", marketId).toLowerCase();
        return this.get(path, this.noSignatureSigner, OrderBookDTO.class, OrderBookDTO::getOrderBook);
    }

    public Balance getBalance(String currency) throws Exception {
        String path = String.format("/api/v2/balances/%s", currency).toLowerCase();
        return this.get(path, this.defaultSigner, BalanceDTO.class, BalanceDTO::getBalance);
    }

    public List<Balance> getBalances() throws Exception {
        return this.get("/api/v2/balances", this.defaultSigner, BalancesDTO.class, BalancesDTO::getBalances);
    }

    public List<Order> getOrders(String marketId) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders", marketId).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, OrdersDTO.class, OrdersDTO::getPagination, OrdersDTO::getOrders);
    }

    public List<Order> getOrders(String marketId, String orderState) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?state=%s&algo=", marketId, orderState).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, OrdersDTO.class, OrdersDTO::getPagination, OrdersDTO::getOrders);
    }

    public List<Order> getOrders(String marketId, BigDecimal minimunExchanged) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?minimun_exchanged=%s", marketId, this.bigDecimalFormat.format(minimunExchanged)).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, OrdersDTO.class, OrdersDTO::getPagination, OrdersDTO::getOrders);
    }

    public List<Order> getOrders(String marketId, String orderState, BigDecimal minimunExchanged) throws Exception {
        String path = String.format("/api/v2/markets/%s/orders?state=%s&minimun_exchanged=%s", marketId, orderState, this.bigDecimalFormat.format(minimunExchanged)).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, OrdersDTO.class, OrdersDTO::getPagination, OrdersDTO::getOrders);
    }

    public Order getOrder(long orderId) throws Exception {
        this.checkOrderId(orderId);
        String path = String.format("/api/v2/orders/%d", orderId).toLowerCase();
        return this.get(path, this.defaultSigner, OrderDTO.class, OrderDTO::getOrder);
    }

    public List<Deposit> getDeposits(String currency) throws Exception {
        String path = String.format("/api/v2/currencies/%s/deposits", currency).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, DepositsDTO.class, DepositsDTO::getPagination, DepositsDTO::getDeposits);
    }

    public List<Withdrawal> getWithdrawals(String currency) throws Exception {
        String path = String.format("/api/v2/currencies/%s/withdrawals", currency).toLowerCase();
        return this.newPaginatedList(path, this.defaultSigner, WithdrawalsDTO.class, WithdrawalsDTO::getPagination, WithdrawalsDTO::getWithdrawals);
    }

    private <T, K> LazyList<T> newPaginatedList(String path, Signer signer, Class<K> dtoType, Function<K, PaginationDTO> getPagination, Function<K, List<T>> getPage) throws Exception {
        return this.get(path, signer, (__, responseBody) -> {
            Object dto = this.json.parse(responseBody, dtoType);
            PaginationDTO pagination = (PaginationDTO)getPagination.apply(dto);
            int totalPages = pagination.getTotalPages();
            int totalCount = pagination.getTotalCount();
            List page = (List)getPage.apply(dto);
            return new LazyList(page, index -> {
                String nextPath = JSurbtc.appendPageParameter(path, index + 1);
                return this.get(nextPath, signer, (__1, responseBody1) -> (List)getPage.apply(this.json.parse(responseBody1, dtoType)));
            }, totalPages, totalCount);
        });
    }

    private static String appendPageParameter(String path, int page) {
        boolean append = path.contains("?");
        return String.format("%s%spage=%d", path, append ? "&" : "?", page);
    }

    private void checkOrderId(long orderId) {
        if (orderId <= 0L) {
            throw new IllegalArgumentException(String.format("invalid order id: %d", orderId));
        }
    }

    private <T, K> K get(String path, Signer signer, Class<T> valueType, Function<T, K> mapper) throws Exception {
        return (K)this.get(path, signer, (__, responseBody) -> mapper.apply(this.json.parse(responseBody, valueType)));
    }

    private <T, K> K get(String path, Signer signer, HTTPClient.HTTPResponseHandler<K> responseHandler) throws Exception {
        return this.httpClient.get(path, signer, this.handlingErrors(responseHandler));
    }

    private <T> T post(String path, Signer signer, Object payload, HTTPClient.HTTPResponseHandler<T> responseHandler) throws Exception {
        return this.httpClient.post(path, signer, this.json.payload(payload), this.handlingErrors(responseHandler));
    }

    private <T, K> HTTPClient.HTTPResponseHandler<K> parser(Class<T> valueType, Function<T, K> mapper) {
        return (statusCode, responseBody) -> mapper.apply(this.json.parse(responseBody, valueType));
    }

    private <T> HTTPClient.HTTPResponseHandler<T> handlingErrors(HTTPClient.HTTPResponseHandler<T> responseHandler) {
        return (statusCode, responseBody) -> {
            boolean successful;
            boolean bl = successful = statusCode == 200 || statusCode == 201;
            if (!successful) {
                ExceptionDTO exceptionDTO = this.json.parse(responseBody, ExceptionDTO.class);
                if (null == exceptionDTO) {
                    throw new Exception(String.format("Surbtc request failed. status code: '%d' response body: '%s'", statusCode, responseBody));
                }
                throw this.error2Error(statusCode, exceptionDTO);
            }
            return responseHandler.handle(statusCode, responseBody);
        };
    }

    private JSurbtcException.Detail error2Error(ExceptionDTO.ErrorDTO in) {
        return new JSurbtcException.Detail(in.resource, in.field, in.code, in.message);
    }

    private JSurbtcException error2Error(int statusCode, ExceptionDTO in) {
        ExceptionDTO.ErrorDTO[] dtos = in.errors == null ? new ExceptionDTO.ErrorDTO[]{} : in.errors;
        JSurbtcException.Detail[] details = (JSurbtcException.Detail[])Arrays.stream(dtos).map(this::error2Error).toArray(JSurbtcException.Detail[]::new);
        return new JSurbtcException(statusCode, in.message, in.code, details);
    }
}

