/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jsurbtc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.function.Supplier;

public enum JSON {
    INSTANCE;

    private final ObjectMapper objectMapper = JSON.newObjectMapper();

    public static ObjectMapper newObjectMapper() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return new ObjectMapper().setDateFormat((DateFormat)simpleDateFormat).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
    }

    Supplier<String> payload(Object value) {
        return () -> {
            try {
                return this.stringify(value);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
    }

    String stringify(Object value) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(value);
    }

    <T> T parse(String json, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue(json, valueType);
    }
}

