/*
 * Decompiled with CFR 0.152.
 */
package cl.daplay.jrut;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JRut
implements Comparable<JRut>,
Serializable {
    private static final String DVS = "_123456789K0";
    private static final DecimalFormat FMT;
    private static final int[] MULTIPLIERS;
    private static final Pattern FILTER;
    private static final Pattern EXPECTED;
    private final int num;
    private final String number;
    private final String dv;
    private final String toString;

    private static String filter(String _rut) {
        if (_rut == null || _rut.trim().length() == 0) {
            throw new IllegalArgumentException("JRut. Can't create instance on empty argument");
        }
        if (_rut.length() <= 1) {
            throw new IllegalArgumentException(String.format("JRut. Can't create instance on '%s'", _rut));
        }
        String rut = FILTER.matcher(_rut).replaceAll("").trim().toUpperCase();
        if (rut.length() <= 1 || !EXPECTED.matcher(rut).matches()) {
            throw new IllegalArgumentException(String.format("JRut. Invalid input '%s'", _rut));
        }
        return rut;
    }

    public static String dv(String _number) {
        String number = JRut.filter(_number);
        int multiplier = 0;
        int sum = 0;
        for (int i = number.length() - 1; i >= 0; --i) {
            int it = Integer.parseInt(number.substring(i, i + 1));
            sum += it * MULTIPLIERS[multiplier];
            multiplier = multiplier + 1 == MULTIPLIERS.length ? 0 : multiplier + 1;
        }
        int mod11 = sum % 11;
        int dv = 11 - mod11;
        return DVS.substring(dv, dv + 1);
    }

    public JRut(String _rut) throws IllegalArgumentException {
        String rut = JRut.filter(_rut);
        int len = rut.length();
        this.number = rut.substring(0, len - 1);
        this.dv = rut.substring(len - 1);
        String expectedDV = JRut.dv(this.number);
        if (!this.dv.equals(expectedDV)) {
            String t = "Illegal DV for input: '%s', dv should be: '%s' instead of '%s'";
            String m = String.format("Illegal DV for input: '%s', dv should be: '%s' instead of '%s'", _rut, expectedDV, this.dv);
            throw new IllegalArgumentException(m);
        }
        this.toString = FMT.format(Integer.parseInt(this.number)) + "-" + this.dv;
        this.num = Integer.parseInt(this.number, 10);
    }

    @Override
    public int compareTo(JRut _other) {
        if (null == _other) {
            throw new IllegalArgumentException("JRut. comparing JRut instance to null");
        }
        JRut other = _other;
        if (this.num < other.num) {
            return -1;
        }
        if (this.num > other.num) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JRut jRut = (JRut)o;
        return this.num == jRut.num;
    }

    public int hashCode() {
        return this.num;
    }

    public String getNumber() {
        return this.number;
    }

    public String getDv() {
        return this.dv;
    }

    public String toString() {
        return this.toString;
    }

    static {
        NumberFormat _fmt = NumberFormat.getInstance();
        if (!(_fmt instanceof NumberFormat)) {
            throw new IllegalStateException("JRut, Can't create NumberFormat");
        }
        DecimalFormat fmt = (DecimalFormat)_fmt;
        DecimalFormatSymbols symbols = fmt.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('.');
        fmt.setDecimalFormatSymbols(symbols);
        fmt.setMaximumFractionDigits(0);
        fmt.setMinimumFractionDigits(0);
        fmt.setGroupingSize(3);
        fmt.setGroupingUsed(true);
        FMT = fmt;
        MULTIPLIERS = new int[]{2, 3, 4, 5, 6, 7};
        FILTER = Pattern.compile("(?i)[^\\dk]");
        EXPECTED = Pattern.compile("^\\d+[K\\d]?$");
    }
}

