/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.utils;

import chat.octet.model.beans.ChatMessage;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.hubspot.jinjava.Jinjava;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatFormatter {
    private static final Logger log = LoggerFactory.getLogger(ChatFormatter.class);
    public static final String DEFAULT_COMMON_SYSTEM = "You are a helpful, respectful and honest assistant. Always answer as helpfully as possible, while being safe.  Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature.\nIf a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question, please don't share false information.";
    public static final String CHATML_CHAT_TEMPLATE = "{% for message in messages %}{{'<|im_start|>' + message['role'] + '\n' + message['content'] + '<|im_end|>' + '\n'}}{% endfor %}{% if add_generation_prompt %}{{ '<|im_start|>assistant\n' }}{% endif %}";
    public static final String CHATML_BOS_TOKEN = "<s>";
    public static final String CHATML_EOS_TOKEN = "<|im_end|>";
    private final Jinjava jinJava = new Jinjava();
    private final String template;
    private final String bos;
    private final String eos;

    public ChatFormatter(String template, String bos, String eos) {
        this.template = template;
        this.bos = bos;
        this.eos = eos;
    }

    public ChatFormatter(String template) {
        this(template, "", "");
    }

    public ChatFormatter() {
        this(CHATML_CHAT_TEMPLATE, CHATML_BOS_TOKEN, CHATML_EOS_TOKEN);
    }

    public String format(boolean addGenerationPrompt, ChatMessage ... messages) {
        Preconditions.checkNotNull((Object)messages, (Object)"Chat messages cannot be null");
        LinkedHashMap context = Maps.newLinkedHashMap();
        context.put("messages", Arrays.asList(messages));
        if (StringUtils.contains((CharSequence)this.template, (CharSequence)"bos_token")) {
            context.put("bos_token", this.bos);
        }
        if (StringUtils.contains((CharSequence)this.template, (CharSequence)"eos_token")) {
            context.put("eos_token", this.eos);
        }
        if (StringUtils.contains((CharSequence)this.template, (CharSequence)"add_generation_prompt")) {
            context.put("add_generation_prompt", addGenerationPrompt);
        }
        return this.jinJava.render(this.template, (Map)context);
    }

    public String format(ChatMessage ... messages) {
        return this.format(true, messages);
    }

    public String format(String system, String question) {
        Preconditions.checkNotNull((Object)question, (Object)"User question cannot be null");
        if (StringUtils.isNotBlank((CharSequence)system)) {
            return this.format(ChatMessage.toSystem(system), ChatMessage.toUser(question));
        }
        return this.format(ChatMessage.toUser(question));
    }

    public String format(String question) {
        return this.format(null, question);
    }

    public String getTemplate() {
        return this.template;
    }

    public String getBos() {
        return this.bos;
    }

    public String getEos() {
        return this.eos;
    }
}

