/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.parameters;

import chat.octet.model.enums.LlamaNumaStrategy;
import chat.octet.model.enums.LlamaPoolingType;
import chat.octet.model.enums.LlamaRoPEScalingType;
import chat.octet.model.enums.LlamaSplitMode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonDeserialize(builder=ModelParameterBuilder.class)
public class ModelParameter {
    private String modelPath;
    @Nullable
    private String loraBase;
    @Nullable
    private String loraPath;
    private float loraScale;
    private boolean verbose;
    private int numaStrategy;
    private int seed;
    private int contextSize;
    private int batchSize;
    private int ubatch;
    private int seqMax;
    private int threads;
    private int threadsBatch;
    private int ropeScalingType;
    private int poolingType;
    private float ropeFreqBase;
    private float ropeFreqScale;
    private float yarnExtFactor;
    private float yarnAttnFactor;
    private float yarnBetaFast;
    private float yarnBetaSlow;
    private int yarnOrigCtx;
    private float defragThold;
    private boolean logitsAll;
    private boolean embedding;
    private boolean offloadKqv;
    private boolean flashAttn;
    private int gpuLayers;
    private int splitMode;
    private int mainGpu;
    @Nullable
    private float[] tensorSplit;
    private boolean vocabOnly;
    private boolean mmap;
    private boolean mlock;
    private boolean checkTensors;

    private static boolean $default$verbose() {
        return false;
    }

    private static int $default$numaStrategy() {
        return LlamaNumaStrategy.NUMA_STRATEGY_DISABLED.getType();
    }

    private static int $default$seed() {
        return -1;
    }

    private static int $default$contextSize() {
        return 512;
    }

    private static int $default$batchSize() {
        return 2048;
    }

    private static int $default$ubatch() {
        return 512;
    }

    private static int $default$seqMax() {
        return 1;
    }

    private static int $default$threads() {
        return 4;
    }

    private static int $default$threadsBatch() {
        return 4;
    }

    private static int $default$ropeScalingType() {
        return LlamaRoPEScalingType.LLAMA_ROPE_SCALING_UNSPECIFIED.getType();
    }

    private static int $default$poolingType() {
        return LlamaPoolingType.LLAMA_POOLING_TYPE_UNSPECIFIED.getType();
    }

    private static float $default$ropeFreqBase() {
        return 0.0f;
    }

    private static float $default$ropeFreqScale() {
        return 0.0f;
    }

    private static float $default$yarnExtFactor() {
        return -1.0f;
    }

    private static float $default$yarnAttnFactor() {
        return 1.0f;
    }

    private static float $default$yarnBetaFast() {
        return 32.0f;
    }

    private static float $default$yarnBetaSlow() {
        return 1.0f;
    }

    private static float $default$defragThold() {
        return -1.0f;
    }

    private static boolean $default$logitsAll() {
        return false;
    }

    private static boolean $default$embedding() {
        return false;
    }

    private static boolean $default$offloadKqv() {
        return true;
    }

    private static boolean $default$flashAttn() {
        return false;
    }

    private static int $default$gpuLayers() {
        return 0;
    }

    private static int $default$splitMode() {
        return LlamaSplitMode.LLAMA_SPLIT_MODE_LAYER.getType();
    }

    private static int $default$mainGpu() {
        return 0;
    }

    private static boolean $default$vocabOnly() {
        return false;
    }

    private static boolean $default$mmap() {
        return true;
    }

    private static boolean $default$mlock() {
        return false;
    }

    private static boolean $default$checkTensors() {
        return false;
    }

    ModelParameter(String modelPath, @Nullable String loraBase, @Nullable String loraPath, float loraScale, boolean verbose, int numaStrategy, int seed, int contextSize, int batchSize, int ubatch, int seqMax, int threads, int threadsBatch, int ropeScalingType, int poolingType, float ropeFreqBase, float ropeFreqScale, float yarnExtFactor, float yarnAttnFactor, float yarnBetaFast, float yarnBetaSlow, int yarnOrigCtx, float defragThold, boolean logitsAll, boolean embedding, boolean offloadKqv, boolean flashAttn, int gpuLayers, int splitMode, int mainGpu, @Nullable float[] tensorSplit, boolean vocabOnly, boolean mmap, boolean mlock, boolean checkTensors) {
        this.modelPath = modelPath;
        this.loraBase = loraBase;
        this.loraPath = loraPath;
        this.loraScale = loraScale;
        this.verbose = verbose;
        this.numaStrategy = numaStrategy;
        this.seed = seed;
        this.contextSize = contextSize;
        this.batchSize = batchSize;
        this.ubatch = ubatch;
        this.seqMax = seqMax;
        this.threads = threads;
        this.threadsBatch = threadsBatch;
        this.ropeScalingType = ropeScalingType;
        this.poolingType = poolingType;
        this.ropeFreqBase = ropeFreqBase;
        this.ropeFreqScale = ropeFreqScale;
        this.yarnExtFactor = yarnExtFactor;
        this.yarnAttnFactor = yarnAttnFactor;
        this.yarnBetaFast = yarnBetaFast;
        this.yarnBetaSlow = yarnBetaSlow;
        this.yarnOrigCtx = yarnOrigCtx;
        this.defragThold = defragThold;
        this.logitsAll = logitsAll;
        this.embedding = embedding;
        this.offloadKqv = offloadKqv;
        this.flashAttn = flashAttn;
        this.gpuLayers = gpuLayers;
        this.splitMode = splitMode;
        this.mainGpu = mainGpu;
        this.tensorSplit = tensorSplit;
        this.vocabOnly = vocabOnly;
        this.mmap = mmap;
        this.mlock = mlock;
        this.checkTensors = checkTensors;
    }

    public static ModelParameterBuilder builder() {
        return new ModelParameterBuilder();
    }

    public String getModelPath() {
        return this.modelPath;
    }

    @Nullable
    public String getLoraBase() {
        return this.loraBase;
    }

    @Nullable
    public String getLoraPath() {
        return this.loraPath;
    }

    public float getLoraScale() {
        return this.loraScale;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getNumaStrategy() {
        return this.numaStrategy;
    }

    public int getSeed() {
        return this.seed;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getUbatch() {
        return this.ubatch;
    }

    public int getSeqMax() {
        return this.seqMax;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getThreadsBatch() {
        return this.threadsBatch;
    }

    public int getRopeScalingType() {
        return this.ropeScalingType;
    }

    public int getPoolingType() {
        return this.poolingType;
    }

    public float getRopeFreqBase() {
        return this.ropeFreqBase;
    }

    public float getRopeFreqScale() {
        return this.ropeFreqScale;
    }

    public float getYarnExtFactor() {
        return this.yarnExtFactor;
    }

    public float getYarnAttnFactor() {
        return this.yarnAttnFactor;
    }

    public float getYarnBetaFast() {
        return this.yarnBetaFast;
    }

    public float getYarnBetaSlow() {
        return this.yarnBetaSlow;
    }

    public int getYarnOrigCtx() {
        return this.yarnOrigCtx;
    }

    public float getDefragThold() {
        return this.defragThold;
    }

    public boolean isLogitsAll() {
        return this.logitsAll;
    }

    public boolean isEmbedding() {
        return this.embedding;
    }

    public boolean isOffloadKqv() {
        return this.offloadKqv;
    }

    public boolean isFlashAttn() {
        return this.flashAttn;
    }

    public int getGpuLayers() {
        return this.gpuLayers;
    }

    public int getSplitMode() {
        return this.splitMode;
    }

    public int getMainGpu() {
        return this.mainGpu;
    }

    @Nullable
    public float[] getTensorSplit() {
        return this.tensorSplit;
    }

    public boolean isVocabOnly() {
        return this.vocabOnly;
    }

    public boolean isMmap() {
        return this.mmap;
    }

    public boolean isMlock() {
        return this.mlock;
    }

    public boolean isCheckTensors() {
        return this.checkTensors;
    }

    public String toString() {
        return "ModelParameter(modelPath=" + this.getModelPath() + ", loraBase=" + this.getLoraBase() + ", loraPath=" + this.getLoraPath() + ", loraScale=" + this.getLoraScale() + ", verbose=" + this.isVerbose() + ", numaStrategy=" + this.getNumaStrategy() + ", seed=" + this.getSeed() + ", contextSize=" + this.getContextSize() + ", batchSize=" + this.getBatchSize() + ", ubatch=" + this.getUbatch() + ", seqMax=" + this.getSeqMax() + ", threads=" + this.getThreads() + ", threadsBatch=" + this.getThreadsBatch() + ", ropeScalingType=" + this.getRopeScalingType() + ", poolingType=" + this.getPoolingType() + ", ropeFreqBase=" + this.getRopeFreqBase() + ", ropeFreqScale=" + this.getRopeFreqScale() + ", yarnExtFactor=" + this.getYarnExtFactor() + ", yarnAttnFactor=" + this.getYarnAttnFactor() + ", yarnBetaFast=" + this.getYarnBetaFast() + ", yarnBetaSlow=" + this.getYarnBetaSlow() + ", yarnOrigCtx=" + this.getYarnOrigCtx() + ", defragThold=" + this.getDefragThold() + ", logitsAll=" + this.isLogitsAll() + ", embedding=" + this.isEmbedding() + ", offloadKqv=" + this.isOffloadKqv() + ", flashAttn=" + this.isFlashAttn() + ", gpuLayers=" + this.getGpuLayers() + ", splitMode=" + this.getSplitMode() + ", mainGpu=" + this.getMainGpu() + ", tensorSplit=" + Arrays.toString(this.getTensorSplit()) + ", vocabOnly=" + this.isVocabOnly() + ", mmap=" + this.isMmap() + ", mlock=" + this.isMlock() + ", checkTensors=" + this.isCheckTensors() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ModelParameterBuilder {
        private String modelPath;
        private String loraBase;
        private String loraPath;
        private float loraScale;
        private boolean verbose$set;
        private boolean verbose$value;
        private boolean numaStrategy$set;
        private int numaStrategy$value;
        private boolean seed$set;
        private int seed$value;
        private boolean contextSize$set;
        private int contextSize$value;
        private boolean batchSize$set;
        private int batchSize$value;
        private boolean ubatch$set;
        private int ubatch$value;
        private boolean seqMax$set;
        private int seqMax$value;
        private boolean threads$set;
        private int threads$value;
        private boolean threadsBatch$set;
        private int threadsBatch$value;
        private boolean ropeScalingType$set;
        private int ropeScalingType$value;
        private boolean poolingType$set;
        private int poolingType$value;
        private boolean ropeFreqBase$set;
        private float ropeFreqBase$value;
        private boolean ropeFreqScale$set;
        private float ropeFreqScale$value;
        private boolean yarnExtFactor$set;
        private float yarnExtFactor$value;
        private boolean yarnAttnFactor$set;
        private float yarnAttnFactor$value;
        private boolean yarnBetaFast$set;
        private float yarnBetaFast$value;
        private boolean yarnBetaSlow$set;
        private float yarnBetaSlow$value;
        private int yarnOrigCtx;
        private boolean defragThold$set;
        private float defragThold$value;
        private boolean logitsAll$set;
        private boolean logitsAll$value;
        private boolean embedding$set;
        private boolean embedding$value;
        private boolean offloadKqv$set;
        private boolean offloadKqv$value;
        private boolean flashAttn$set;
        private boolean flashAttn$value;
        private boolean gpuLayers$set;
        private int gpuLayers$value;
        private boolean splitMode$set;
        private int splitMode$value;
        private boolean mainGpu$set;
        private int mainGpu$value;
        private float[] tensorSplit;
        private boolean vocabOnly$set;
        private boolean vocabOnly$value;
        private boolean mmap$set;
        private boolean mmap$value;
        private boolean mlock$set;
        private boolean mlock$value;
        private boolean checkTensors$set;
        private boolean checkTensors$value;

        ModelParameterBuilder() {
        }

        public ModelParameterBuilder modelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public ModelParameterBuilder loraBase(@Nullable String loraBase) {
            this.loraBase = loraBase;
            return this;
        }

        public ModelParameterBuilder loraPath(@Nullable String loraPath) {
            this.loraPath = loraPath;
            return this;
        }

        public ModelParameterBuilder loraScale(float loraScale) {
            this.loraScale = loraScale;
            return this;
        }

        public ModelParameterBuilder verbose(boolean verbose) {
            this.verbose$value = verbose;
            this.verbose$set = true;
            return this;
        }

        public ModelParameterBuilder numaStrategy(int numaStrategy) {
            this.numaStrategy$value = numaStrategy;
            this.numaStrategy$set = true;
            return this;
        }

        public ModelParameterBuilder seed(int seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public ModelParameterBuilder contextSize(int contextSize) {
            this.contextSize$value = contextSize;
            this.contextSize$set = true;
            return this;
        }

        public ModelParameterBuilder batchSize(int batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this;
        }

        public ModelParameterBuilder ubatch(int ubatch) {
            this.ubatch$value = ubatch;
            this.ubatch$set = true;
            return this;
        }

        public ModelParameterBuilder seqMax(int seqMax) {
            this.seqMax$value = seqMax;
            this.seqMax$set = true;
            return this;
        }

        public ModelParameterBuilder threads(int threads) {
            this.threads$value = threads;
            this.threads$set = true;
            return this;
        }

        public ModelParameterBuilder threadsBatch(int threadsBatch) {
            this.threadsBatch$value = threadsBatch;
            this.threadsBatch$set = true;
            return this;
        }

        public ModelParameterBuilder ropeScalingType(int ropeScalingType) {
            this.ropeScalingType$value = ropeScalingType;
            this.ropeScalingType$set = true;
            return this;
        }

        public ModelParameterBuilder poolingType(int poolingType) {
            this.poolingType$value = poolingType;
            this.poolingType$set = true;
            return this;
        }

        public ModelParameterBuilder ropeFreqBase(float ropeFreqBase) {
            this.ropeFreqBase$value = ropeFreqBase;
            this.ropeFreqBase$set = true;
            return this;
        }

        public ModelParameterBuilder ropeFreqScale(float ropeFreqScale) {
            this.ropeFreqScale$value = ropeFreqScale;
            this.ropeFreqScale$set = true;
            return this;
        }

        public ModelParameterBuilder yarnExtFactor(float yarnExtFactor) {
            this.yarnExtFactor$value = yarnExtFactor;
            this.yarnExtFactor$set = true;
            return this;
        }

        public ModelParameterBuilder yarnAttnFactor(float yarnAttnFactor) {
            this.yarnAttnFactor$value = yarnAttnFactor;
            this.yarnAttnFactor$set = true;
            return this;
        }

        public ModelParameterBuilder yarnBetaFast(float yarnBetaFast) {
            this.yarnBetaFast$value = yarnBetaFast;
            this.yarnBetaFast$set = true;
            return this;
        }

        public ModelParameterBuilder yarnBetaSlow(float yarnBetaSlow) {
            this.yarnBetaSlow$value = yarnBetaSlow;
            this.yarnBetaSlow$set = true;
            return this;
        }

        public ModelParameterBuilder yarnOrigCtx(int yarnOrigCtx) {
            this.yarnOrigCtx = yarnOrigCtx;
            return this;
        }

        public ModelParameterBuilder defragThold(float defragThold) {
            this.defragThold$value = defragThold;
            this.defragThold$set = true;
            return this;
        }

        public ModelParameterBuilder logitsAll(boolean logitsAll) {
            this.logitsAll$value = logitsAll;
            this.logitsAll$set = true;
            return this;
        }

        public ModelParameterBuilder embedding(boolean embedding) {
            this.embedding$value = embedding;
            this.embedding$set = true;
            return this;
        }

        public ModelParameterBuilder offloadKqv(boolean offloadKqv) {
            this.offloadKqv$value = offloadKqv;
            this.offloadKqv$set = true;
            return this;
        }

        public ModelParameterBuilder flashAttn(boolean flashAttn) {
            this.flashAttn$value = flashAttn;
            this.flashAttn$set = true;
            return this;
        }

        public ModelParameterBuilder gpuLayers(int gpuLayers) {
            this.gpuLayers$value = gpuLayers;
            this.gpuLayers$set = true;
            return this;
        }

        public ModelParameterBuilder splitMode(int splitMode) {
            this.splitMode$value = splitMode;
            this.splitMode$set = true;
            return this;
        }

        public ModelParameterBuilder mainGpu(int mainGpu) {
            this.mainGpu$value = mainGpu;
            this.mainGpu$set = true;
            return this;
        }

        public ModelParameterBuilder tensorSplit(@Nullable float[] tensorSplit) {
            this.tensorSplit = tensorSplit;
            return this;
        }

        public ModelParameterBuilder vocabOnly(boolean vocabOnly) {
            this.vocabOnly$value = vocabOnly;
            this.vocabOnly$set = true;
            return this;
        }

        public ModelParameterBuilder mmap(boolean mmap) {
            this.mmap$value = mmap;
            this.mmap$set = true;
            return this;
        }

        public ModelParameterBuilder mlock(boolean mlock) {
            this.mlock$value = mlock;
            this.mlock$set = true;
            return this;
        }

        public ModelParameterBuilder checkTensors(boolean checkTensors) {
            this.checkTensors$value = checkTensors;
            this.checkTensors$set = true;
            return this;
        }

        public ModelParameter build() {
            boolean verbose$value = this.verbose$value;
            if (!this.verbose$set) {
                verbose$value = ModelParameter.$default$verbose();
            }
            int numaStrategy$value = this.numaStrategy$value;
            if (!this.numaStrategy$set) {
                numaStrategy$value = ModelParameter.$default$numaStrategy();
            }
            int seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = ModelParameter.$default$seed();
            }
            int contextSize$value = this.contextSize$value;
            if (!this.contextSize$set) {
                contextSize$value = ModelParameter.$default$contextSize();
            }
            int batchSize$value = this.batchSize$value;
            if (!this.batchSize$set) {
                batchSize$value = ModelParameter.$default$batchSize();
            }
            int ubatch$value = this.ubatch$value;
            if (!this.ubatch$set) {
                ubatch$value = ModelParameter.$default$ubatch();
            }
            int seqMax$value = this.seqMax$value;
            if (!this.seqMax$set) {
                seqMax$value = ModelParameter.$default$seqMax();
            }
            int threads$value = this.threads$value;
            if (!this.threads$set) {
                threads$value = ModelParameter.$default$threads();
            }
            int threadsBatch$value = this.threadsBatch$value;
            if (!this.threadsBatch$set) {
                threadsBatch$value = ModelParameter.$default$threadsBatch();
            }
            int ropeScalingType$value = this.ropeScalingType$value;
            if (!this.ropeScalingType$set) {
                ropeScalingType$value = ModelParameter.$default$ropeScalingType();
            }
            int poolingType$value = this.poolingType$value;
            if (!this.poolingType$set) {
                poolingType$value = ModelParameter.$default$poolingType();
            }
            float ropeFreqBase$value = this.ropeFreqBase$value;
            if (!this.ropeFreqBase$set) {
                ropeFreqBase$value = ModelParameter.$default$ropeFreqBase();
            }
            float ropeFreqScale$value = this.ropeFreqScale$value;
            if (!this.ropeFreqScale$set) {
                ropeFreqScale$value = ModelParameter.$default$ropeFreqScale();
            }
            float yarnExtFactor$value = this.yarnExtFactor$value;
            if (!this.yarnExtFactor$set) {
                yarnExtFactor$value = ModelParameter.$default$yarnExtFactor();
            }
            float yarnAttnFactor$value = this.yarnAttnFactor$value;
            if (!this.yarnAttnFactor$set) {
                yarnAttnFactor$value = ModelParameter.$default$yarnAttnFactor();
            }
            float yarnBetaFast$value = this.yarnBetaFast$value;
            if (!this.yarnBetaFast$set) {
                yarnBetaFast$value = ModelParameter.$default$yarnBetaFast();
            }
            float yarnBetaSlow$value = this.yarnBetaSlow$value;
            if (!this.yarnBetaSlow$set) {
                yarnBetaSlow$value = ModelParameter.$default$yarnBetaSlow();
            }
            float defragThold$value = this.defragThold$value;
            if (!this.defragThold$set) {
                defragThold$value = ModelParameter.$default$defragThold();
            }
            boolean logitsAll$value = this.logitsAll$value;
            if (!this.logitsAll$set) {
                logitsAll$value = ModelParameter.$default$logitsAll();
            }
            boolean embedding$value = this.embedding$value;
            if (!this.embedding$set) {
                embedding$value = ModelParameter.$default$embedding();
            }
            boolean offloadKqv$value = this.offloadKqv$value;
            if (!this.offloadKqv$set) {
                offloadKqv$value = ModelParameter.$default$offloadKqv();
            }
            boolean flashAttn$value = this.flashAttn$value;
            if (!this.flashAttn$set) {
                flashAttn$value = ModelParameter.$default$flashAttn();
            }
            int gpuLayers$value = this.gpuLayers$value;
            if (!this.gpuLayers$set) {
                gpuLayers$value = ModelParameter.$default$gpuLayers();
            }
            int splitMode$value = this.splitMode$value;
            if (!this.splitMode$set) {
                splitMode$value = ModelParameter.$default$splitMode();
            }
            int mainGpu$value = this.mainGpu$value;
            if (!this.mainGpu$set) {
                mainGpu$value = ModelParameter.$default$mainGpu();
            }
            boolean vocabOnly$value = this.vocabOnly$value;
            if (!this.vocabOnly$set) {
                vocabOnly$value = ModelParameter.$default$vocabOnly();
            }
            boolean mmap$value = this.mmap$value;
            if (!this.mmap$set) {
                mmap$value = ModelParameter.$default$mmap();
            }
            boolean mlock$value = this.mlock$value;
            if (!this.mlock$set) {
                mlock$value = ModelParameter.$default$mlock();
            }
            boolean checkTensors$value = this.checkTensors$value;
            if (!this.checkTensors$set) {
                checkTensors$value = ModelParameter.$default$checkTensors();
            }
            return new ModelParameter(this.modelPath, this.loraBase, this.loraPath, this.loraScale, verbose$value, numaStrategy$value, seed$value, contextSize$value, batchSize$value, ubatch$value, seqMax$value, threads$value, threadsBatch$value, ropeScalingType$value, poolingType$value, ropeFreqBase$value, ropeFreqScale$value, yarnExtFactor$value, yarnAttnFactor$value, yarnBetaFast$value, yarnBetaSlow$value, this.yarnOrigCtx, defragThold$value, logitsAll$value, embedding$value, offloadKqv$value, flashAttn$value, gpuLayers$value, splitMode$value, mainGpu$value, this.tensorSplit, vocabOnly$value, mmap$value, mlock$value, checkTensors$value);
        }

        public String toString() {
            return "ModelParameter.ModelParameterBuilder(modelPath=" + this.modelPath + ", loraBase=" + this.loraBase + ", loraPath=" + this.loraPath + ", loraScale=" + this.loraScale + ", verbose$value=" + this.verbose$value + ", numaStrategy$value=" + this.numaStrategy$value + ", seed$value=" + this.seed$value + ", contextSize$value=" + this.contextSize$value + ", batchSize$value=" + this.batchSize$value + ", ubatch$value=" + this.ubatch$value + ", seqMax$value=" + this.seqMax$value + ", threads$value=" + this.threads$value + ", threadsBatch$value=" + this.threadsBatch$value + ", ropeScalingType$value=" + this.ropeScalingType$value + ", poolingType$value=" + this.poolingType$value + ", ropeFreqBase$value=" + this.ropeFreqBase$value + ", ropeFreqScale$value=" + this.ropeFreqScale$value + ", yarnExtFactor$value=" + this.yarnExtFactor$value + ", yarnAttnFactor$value=" + this.yarnAttnFactor$value + ", yarnBetaFast$value=" + this.yarnBetaFast$value + ", yarnBetaSlow$value=" + this.yarnBetaSlow$value + ", yarnOrigCtx=" + this.yarnOrigCtx + ", defragThold$value=" + this.defragThold$value + ", logitsAll$value=" + this.logitsAll$value + ", embedding$value=" + this.embedding$value + ", offloadKqv$value=" + this.offloadKqv$value + ", flashAttn$value=" + this.flashAttn$value + ", gpuLayers$value=" + this.gpuLayers$value + ", splitMode$value=" + this.splitMode$value + ", mainGpu$value=" + this.mainGpu$value + ", tensorSplit=" + Arrays.toString(this.tensorSplit) + ", vocabOnly$value=" + this.vocabOnly$value + ", mmap$value=" + this.mmap$value + ", mlock$value=" + this.mlock$value + ", checkTensors$value=" + this.checkTensors$value + ")";
        }
    }
}

