/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LlamaTokenAttr {
    LLAMA_TOKEN_ATTR_UNDEFINED(0),
    LLAMA_TOKEN_ATTR_UNKNOWN(1),
    LLAMA_TOKEN_ATTR_UNUSED(2),
    LLAMA_TOKEN_ATTR_NORMAL(4),
    LLAMA_TOKEN_ATTR_CONTROL(8),
    LLAMA_TOKEN_ATTR_USER_DEFINED(16),
    LLAMA_TOKEN_ATTR_BYTE(32),
    LLAMA_TOKEN_ATTR_NORMALIZED(64),
    LLAMA_TOKEN_ATTR_LSTRIP(128),
    LLAMA_TOKEN_ATTR_RSTRIP(256),
    LLAMA_TOKEN_ATTR_SINGLE_WORD(512);

    private static final Map<Integer, LlamaTokenAttr> TYPES;
    private final int type;

    private LlamaTokenAttr(int type) {
        this.type = type;
    }

    public static LlamaTokenAttr valueOfType(int type) {
        return TYPES.get(type);
    }

    public String toString() {
        return this.name();
    }

    public int getType() {
        return this.type;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (LlamaTokenAttr type : LlamaTokenAttr.values()) {
            if (map.put(type.type, type) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + type.name());
        }
        TYPES = Collections.unmodifiableMap(map);
    }
}

