/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LlamaSplitMode {
    LLAMA_SPLIT_MODE_NONE(0),
    LLAMA_SPLIT_MODE_LAYER(1),
    LLAMA_SPLIT_MODE_ROW(2);

    private static final Map<Integer, LlamaSplitMode> TYPES;
    private final int type;

    private LlamaSplitMode(int type) {
        this.type = type;
    }

    public static LlamaSplitMode valueOfType(int type) {
        return TYPES.get(type);
    }

    public String toString() {
        return this.name();
    }

    public int getType() {
        return this.type;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (LlamaSplitMode type : LlamaSplitMode.values()) {
            if (map.put(type.type, type) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + type.name());
        }
        TYPES = Collections.unmodifiableMap(map);
    }
}

