/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LlamaPoolingType {
    LLAMA_POOLING_TYPE_UNSPECIFIED(-1),
    LLAMA_POOLING_TYPE_NONE(0),
    LLAMA_POOLING_TYPE_MEAN(1),
    LLAMA_POOLING_TYPE_CLS(2);

    private static final Map<Integer, LlamaPoolingType> TYPES;
    private final int type;

    private LlamaPoolingType(int type) {
        this.type = type;
    }

    public static LlamaPoolingType valueOfType(int type) {
        return TYPES.get(type);
    }

    public String toString() {
        return this.name();
    }

    public int getType() {
        return this.type;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (LlamaPoolingType type : LlamaPoolingType.values()) {
            if (map.put(type.type, type) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + type.name());
        }
        TYPES = Collections.unmodifiableMap(map);
    }
}

