/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LlamaNumaStrategy {
    NUMA_STRATEGY_DISABLED(0),
    NUMA_STRATEGY_DISTRIBUTE(1),
    NUMA_STRATEGY_ISOLATE(2),
    NUMA_STRATEGY_NUMACTL(3),
    NUMA_STRATEGY_MIRROR(4),
    NUMA_STRATEGY_COUNT(5);

    private static final Map<Integer, LlamaNumaStrategy> TYPES;
    private final int type;

    private LlamaNumaStrategy(int type) {
        this.type = type;
    }

    public static LlamaNumaStrategy valueOfType(int type) {
        return TYPES.get(type);
    }

    public String toString() {
        return this.name();
    }

    public int getType() {
        return this.type;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (LlamaNumaStrategy type : LlamaNumaStrategy.values()) {
            if (map.put(type.type, type) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + type.name());
        }
        TYPES = Collections.unmodifiableMap(map);
    }
}

