/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.components.criteria;

import chat.octet.model.components.criteria.StoppingCriteria;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoppingCriteriaList
implements StoppingCriteria {
    private static final Logger log = LoggerFactory.getLogger(StoppingCriteriaList.class);
    private final Set<StoppingCriteria> criteriaSet = Sets.newHashSet();

    public StoppingCriteriaList add(StoppingCriteria criteria) {
        for (StoppingCriteria c : this.criteriaSet) {
            if (c.getClass() != criteria.getClass()) continue;
            return this;
        }
        this.criteriaSet.add(criteria);
        return this;
    }

    public boolean isEmpty() {
        return this.criteriaSet.isEmpty();
    }

    @Override
    public boolean criteria(@Nullable int[] inputTokenIds, @Nonnull float[] scores, Object ... args) {
        for (StoppingCriteria criteria : this.criteriaSet) {
            if (!criteria.criteria(inputTokenIds, scores, args)) continue;
            log.debug("Matched stop criteria, criteria name: {}.", (Object)criteria.getClass().getName());
            return true;
        }
        return false;
    }
}

