/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.beans;

import chat.octet.model.enums.FinishReason;
import chat.octet.model.enums.LlamaTokenAttr;
import java.io.Serializable;
import java.util.Objects;

public final class Token
implements Serializable {
    private final int id;
    private final String text;
    private final LlamaTokenAttr tokenAttr;
    private FinishReason finishReason;

    public Token(int id, LlamaTokenAttr tokenAttr, String text) {
        this.id = id;
        this.text = text;
        this.tokenAttr = tokenAttr;
        this.finishReason = FinishReason.NONE;
    }

    public void updateFinishReason(FinishReason finishReason) {
        this.finishReason = finishReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token token = (Token)o;
        return this.id == token.id && Objects.equals(this.text, token.text);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text);
    }

    public int getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public LlamaTokenAttr getTokenAttr() {
        return this.tokenAttr;
    }

    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    public String toString() {
        return "Token(id=" + this.getId() + ", text=" + this.getText() + ", tokenAttr=" + (Object)((Object)this.getTokenAttr()) + ", finishReason=" + (Object)((Object)this.getFinishReason()) + ")";
    }
}

