/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.beans;

import java.text.MessageFormat;

public class Metrics {
    public static final String METRICS_TEMPLATE = "\n\t   load time =\t{0,number,#.##} ms\n\t sample time =\t{1,number,#.##} ms / {2} runs\t( {3,number,#.##} ms per token, {4,number,#.##} tokens per second)\nprompt eval time =\t{5,number,#.##} ms / {6} tokens\t( {7,number,#.##} ms per token, {8,number,#.##} tokens per second)\n\t   eval time =\t{9,number,#.##} ms / {10} runs\t( {11,number,#.##} ms per token, {12,number,#.##} tokens per second)\n\t  total time =\t{13,number,#.##} ms";
    private double startTimeMs;
    private double endTimeMs;
    private double loadTimeMs;
    private double sampleTimeMs;
    private double promptEvalTimeMs;
    private double evalTimeMs;
    private int sampleCount;
    private int promptEvalCount;
    private int evalCount;

    public String toString() {
        return MessageFormat.format(METRICS_TEMPLATE, this.loadTimeMs, this.sampleTimeMs, this.sampleCount, this.sampleTimeMs / (double)this.sampleCount, 1000.0 / this.sampleTimeMs * (double)this.sampleCount, this.promptEvalTimeMs, this.promptEvalCount, this.promptEvalTimeMs / (double)this.promptEvalCount, 1000.0 / this.promptEvalTimeMs * (double)this.promptEvalCount, this.evalTimeMs, this.evalCount, this.evalTimeMs / (double)this.evalCount, 1000.0 / this.evalTimeMs * (double)this.evalCount, this.endTimeMs - this.startTimeMs);
    }

    public double getStartTimeMs() {
        return this.startTimeMs;
    }

    public double getEndTimeMs() {
        return this.endTimeMs;
    }

    public double getLoadTimeMs() {
        return this.loadTimeMs;
    }

    public double getSampleTimeMs() {
        return this.sampleTimeMs;
    }

    public double getPromptEvalTimeMs() {
        return this.promptEvalTimeMs;
    }

    public double getEvalTimeMs() {
        return this.evalTimeMs;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getPromptEvalCount() {
        return this.promptEvalCount;
    }

    public int getEvalCount() {
        return this.evalCount;
    }

    public void setStartTimeMs(double startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public void setEndTimeMs(double endTimeMs) {
        this.endTimeMs = endTimeMs;
    }

    public void setLoadTimeMs(double loadTimeMs) {
        this.loadTimeMs = loadTimeMs;
    }

    public void setSampleTimeMs(double sampleTimeMs) {
        this.sampleTimeMs = sampleTimeMs;
    }

    public void setPromptEvalTimeMs(double promptEvalTimeMs) {
        this.promptEvalTimeMs = promptEvalTimeMs;
    }

    public void setEvalTimeMs(double evalTimeMs) {
        this.evalTimeMs = evalTimeMs;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public void setPromptEvalCount(int promptEvalCount) {
        this.promptEvalCount = promptEvalCount;
    }

    public void setEvalCount(int evalCount) {
        this.evalCount = evalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metrics)) {
            return false;
        }
        Metrics other = (Metrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getStartTimeMs(), other.getStartTimeMs()) != 0) {
            return false;
        }
        if (Double.compare(this.getEndTimeMs(), other.getEndTimeMs()) != 0) {
            return false;
        }
        if (Double.compare(this.getLoadTimeMs(), other.getLoadTimeMs()) != 0) {
            return false;
        }
        if (Double.compare(this.getSampleTimeMs(), other.getSampleTimeMs()) != 0) {
            return false;
        }
        if (Double.compare(this.getPromptEvalTimeMs(), other.getPromptEvalTimeMs()) != 0) {
            return false;
        }
        if (Double.compare(this.getEvalTimeMs(), other.getEvalTimeMs()) != 0) {
            return false;
        }
        if (this.getSampleCount() != other.getSampleCount()) {
            return false;
        }
        if (this.getPromptEvalCount() != other.getPromptEvalCount()) {
            return false;
        }
        return this.getEvalCount() == other.getEvalCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Metrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTimeMs = Double.doubleToLongBits(this.getStartTimeMs());
        result = result * 59 + (int)($startTimeMs >>> 32 ^ $startTimeMs);
        long $endTimeMs = Double.doubleToLongBits(this.getEndTimeMs());
        result = result * 59 + (int)($endTimeMs >>> 32 ^ $endTimeMs);
        long $loadTimeMs = Double.doubleToLongBits(this.getLoadTimeMs());
        result = result * 59 + (int)($loadTimeMs >>> 32 ^ $loadTimeMs);
        long $sampleTimeMs = Double.doubleToLongBits(this.getSampleTimeMs());
        result = result * 59 + (int)($sampleTimeMs >>> 32 ^ $sampleTimeMs);
        long $promptEvalTimeMs = Double.doubleToLongBits(this.getPromptEvalTimeMs());
        result = result * 59 + (int)($promptEvalTimeMs >>> 32 ^ $promptEvalTimeMs);
        long $evalTimeMs = Double.doubleToLongBits(this.getEvalTimeMs());
        result = result * 59 + (int)($evalTimeMs >>> 32 ^ $evalTimeMs);
        result = result * 59 + this.getSampleCount();
        result = result * 59 + this.getPromptEvalCount();
        result = result * 59 + this.getEvalCount();
        return result;
    }
}

