/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model;

import chat.octet.model.beans.LlamaContextParams;
import chat.octet.model.beans.LlamaModelParams;
import chat.octet.model.beans.LlamaModelQuantizeParams;
import chat.octet.model.beans.Metrics;
import chat.octet.model.enums.LlamaTokenAttr;
import chat.octet.model.enums.ModelFileType;
import chat.octet.model.exceptions.DecodeException;
import chat.octet.model.exceptions.ModelException;
import chat.octet.model.parameters.GenerateParameter;
import chat.octet.model.utils.Platform;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;

public class LlamaService {
    public static native void initNative();

    public static native LlamaModelParams getLlamaModelDefaultParams();

    public static native LlamaContextParams getLlamaContextDefaultParams();

    public static native LlamaModelQuantizeParams getLlamaModelQuantizeDefaultParams();

    public static native void llamaBackendInit();

    public static native void llamaNumaInit(int var0);

    public static native void llamaBackendFree();

    public static native void loadLlamaModelFromFile(String var0, LlamaModelParams var1) throws ModelException;

    public static native void createNewContextWithModel(LlamaContextParams var0) throws ModelException;

    public static native void release();

    public static native boolean isMmapSupported();

    public static native boolean isMlockSupported();

    public static native boolean isGpuOffloadSupported();

    public static native int getVocabSize();

    public static native int getContextSize();

    public static native int loadLoraModelFromFile(String var0, float var1, String var2, int var3) throws ModelException;

    public static native float[] getLogits(int var0);

    public static native float[] getEmbedding();

    public static native int getTokenAttr(int var0);

    public static native int getTokenBOS();

    public static native int getTokenEOS();

    public static native int tokenize(byte[] var0, int var1, int[] var2, int var3, boolean var4, boolean var5);

    public static native int tokenToPiece(int var0, byte[] var1, int var2, boolean var3);

    public static native Metrics getSamplingMetrics(boolean var0);

    public static native String getSystemInfo();

    public static native int sampling(float[] var0, int[] var1, int var2, float var3, float var4, float var5, boolean var6, int var7, float var8, float var9, float var10, int var11, float var12, float var13, float var14, float var15, float var16, float var17, int var18, int var19) throws DecodeException;

    public static int sampling(GenerateParameter generateParams, float[] logits, int[] lastTokens, int sequenceId, int pastTokenSize) throws DecodeException {
        return LlamaService.sampling(logits, lastTokens, generateParams.getLastTokensSize(), generateParams.getRepeatPenalty(), generateParams.getFrequencyPenalty(), generateParams.getPresencePenalty(), generateParams.isPenalizeNl(), generateParams.getMirostatMode().ordinal(), generateParams.getMirostatTAU(), generateParams.getMirostatETA(), generateParams.getTemperature(), generateParams.getTopK(), generateParams.getTopP(), generateParams.getTsf(), generateParams.getTypical(), generateParams.getMinP(), generateParams.getDynatempRange(), generateParams.getDynatempExponent(), sequenceId, pastTokenSize);
    }

    public static native boolean loadLlamaGrammar(String var0);

    public static native int batchDecode(int var0, int[] var1, int var2, int var3);

    public static native void clearCache(int var0, int var1, int var2);

    public static void clearCache(int sequenceId) {
        LlamaService.clearCache(sequenceId, 0, LlamaService.getContextSize());
    }

    public static native int llamaModelQuantize(String var0, String var1, LlamaModelQuantizeParams var2);

    public static int llamaModelQuantize(String sourceModelFilePath, String outputModelFilePath, ModelFileType modelFileType) {
        if (!Files.exists(new File(sourceModelFilePath).toPath(), new LinkOption[0])) {
            throw new ModelException("Source model file is not exists, please check the file path");
        }
        LlamaModelQuantizeParams defaultParams = LlamaService.getLlamaModelQuantizeDefaultParams();
        defaultParams.modelFileType = modelFileType.getType();
        return LlamaService.llamaModelQuantize(sourceModelFilePath, outputModelFilePath, defaultParams);
    }

    public static int[] tokenize(String text, boolean addBos, boolean specialTokens) {
        Preconditions.checkNotNull((Object)text, (Object)"Text cannot be null");
        int[] tokens = new int[LlamaService.getContextSize()];
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        int nextTokens = LlamaService.tokenize(textBytes, textBytes.length, tokens, LlamaService.getContextSize(), addBos, specialTokens);
        if (nextTokens < 0) {
            throw new ModelException(MessageFormat.format("Failed to tokenize: {0}, next_tokens: {1}", text, nextTokens));
        }
        return ArrayUtils.subarray((int[])tokens, (int)0, (int)nextTokens);
    }

    public static LlamaTokenAttr getLlamaTokenAttr(int token) {
        return LlamaTokenAttr.valueOfType(LlamaService.getTokenAttr(token));
    }

    public static native String llamaModelMeta(String var0);

    static {
        System.load(Platform.LIB_RESOURCE_PATH);
        LlamaService.initNative();
    }
}

