/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.enums;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum LlamaTokenType {
    LLAMA_TOKEN_TYPE_UNDEFINED(0),
    LLAMA_TOKEN_TYPE_NORMAL(1),
    LLAMA_TOKEN_TYPE_UNKNOWN(2),
    LLAMA_TOKEN_TYPE_CONTROL(3),
    LLAMA_TOKEN_TYPE_USER_DEFINED(4),
    LLAMA_TOKEN_TYPE_UNUSED(5),
    LLAMA_TOKEN_TYPE_BYTE(6);

    private final int type;
    private static final Map<Integer, LlamaTokenType> TYPES;

    private LlamaTokenType(int type) {
        this.type = type;
    }

    public static LlamaTokenType valueOfType(int type) {
        return TYPES.get(type);
    }

    public String toString() {
        return this.name();
    }

    public int getType() {
        return this.type;
    }

    static {
        HashMap map = Maps.newHashMap();
        for (LlamaTokenType type : LlamaTokenType.values()) {
            if (map.put(type.type, type) == null) continue;
            throw new IllegalStateException("Duplicated key found: " + type.name());
        }
        TYPES = Collections.unmodifiableMap(map);
    }
}

